// VTC1010_IO_API V1.6 2016/12/12
#define VTC1010_IO_API extern "C" _declspec(dllimport)


VTC1010_IO_API void Get_DLL_Version(int* nMajorVersion, int* nMinorVersion);

VTC1010_IO_API int  Library_Initial(); // Initial Library      // return = 0 => Failed, return = 1 => Success
VTC1010_IO_API void Library_Release(); // Release Library

VTC1010_IO_API int  LED_Control_GetIgnition();         // return = 0 => OFF, return = 1 => ON
VTC1010_IO_API int  Car_Battery_GetStatus();           // return = 0 => Low voltage, return = 1 => OK

VTC1010_IO_API void GPIO_SetGPO_1(int nData);          // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API void GPIO_SetGPO_2(int nData);          // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API void GPIO_SetGPO_3(int nData);          // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API void GPIO_SetGPO_4(int nData);          // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API void GPIO_SetGPO_5(int nData);          // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API void GPIO_SetGPO_6(int nData);          // nData = 0 => Low, nData = 1 => High

VTC1010_IO_API int  GPIO_ReadGPO_1();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPO_2();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPO_3();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPO_4();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPO_5();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPO_6();                  // return = 0 => Low, return = 1 => High

VTC1010_IO_API int  GPIO_ReadGPI_1();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPI_2();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPI_3();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPI_4();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPI_5();                  // return = 0 => Low, return = 1 => High
VTC1010_IO_API int  GPIO_ReadGPI_6();                  // return = 0 => Low, return = 1 => High

VTC1010_IO_API void GPIO_SetGPIO_Status_1(int nData);  // nData = 0 => GPI, nData = 1 => GPO
VTC1010_IO_API void GPIO_SetGPIO_Status_2(int nData);  // nData = 0 => GPI, nData = 1 => GPO
VTC1010_IO_API void GPIO_SetGPIO_Status_3(int nData);  // nData = 0 => GPI, nData = 1 => GPO
VTC1010_IO_API void GPIO_SetGPIO_Status_4(int nData);  // nData = 0 => GPI, nData = 1 => GPO
VTC1010_IO_API void GPIO_SetGPIO_Status_5(int nData);  // nData = 0 => GPI, nData = 1 => GPO
VTC1010_IO_API void GPIO_SetGPIO_Status_6(int nData);  // nData = 0 => GPI, nData = 1 => GPO

VTC1010_IO_API int  GPIO_ReadGPIO_Status_1();          // return = 0 => GPI, return = 1 => GPO
VTC1010_IO_API int  GPIO_ReadGPIO_Status_2();          // return = 0 => GPI, return = 1 => GPO
VTC1010_IO_API int  GPIO_ReadGPIO_Status_3();          // return = 0 => GPI, return = 1 => GPO
VTC1010_IO_API int  GPIO_ReadGPIO_Status_4();          // return = 0 => GPI, return = 1 => GPO
VTC1010_IO_API int  GPIO_ReadGPIO_Status_5();          // return = 0 => GPI, return = 1 => GPO
VTC1010_IO_API int  GPIO_ReadGPIO_Status_6();          // return = 0 => GPI, return = 1 => GPO

VTC1010_IO_API void WDT_Switch(int nStatus);           // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  WDT_Switch_Get();                  // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void WDT_Time_Setting(int nData);       // nData = 0 =>   1 sec
                                                       // nData = 1 =>   2 sec
                                                       // nData = 2 =>   4 sec
                                                       // nData = 3 =>   8 sec
                                                       // nData = 4 =>  16 sec
                                                       // nData = 5 =>  32 sec
                                                       // nData = 6 =>  64 sec
                                                       // nData = 7 => 128 sec
                                                       // nData = 8 => 256 sec
VTC1010_IO_API int  WDT_Time_Setting_Get();            // return timeout 
VTC1010_IO_API void WDT_Clear_Timer(void);             // clear WDT timer

VTC1010_IO_API void EXTERNAL_12V_Power(int nStatus);   // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  EXTERNAL_12V_Power_Get();          // return = 0 => DISABLE, return = 1 => ENABLE

VTC1010_IO_API void Power_On_Delay(int nStatus);       // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Power_On_Delay_Get();              // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Power_On_Delay_Time(int nData);    // nData = 0 => 10 sec
                                                       // nData = 1 => 30 sec
                                                       // nData = 2 =>  1 min
                                                       // nData = 3 =>  5 min
                                                       // nData = 4 => 10 min
                                                       // nData = 5 => 15 min
                                                       // nData = 6 => 30 min
                                                       // nData = 7 =>  1 hour
VTC1010_IO_API int  Power_On_Delay_Time_Get();         // 

VTC1010_IO_API void Power_Off_Delay(int nStatus);      // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Power_Off_Delay_Get();             // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Power_Off_Delay_Time(int nData);   // nData = 0 => 20 sec
                                                       // nData = 1 =>  1 min
                                                       // nData = 2 =>  5 min
                                                       // nData = 3 => 10 min
                                                       // nData = 4 => 30 min
                                                       // nData = 5 =>  1 hour
                                                       // nData = 6 =>  6 hour
                                                       // nData = 7 => 18 hour
VTC1010_IO_API int  Power_Off_Delay_Time_Get();        // 

VTC1010_IO_API int  Voltage_Get();                     // return = 0 => 9V~36V
                                                       // return = 1 => 24V
                                                       // return = 2 => 9V~36V
                                                       // return = 3 => 12V
VTC1010_IO_API void Voltage_Select_Setting(int nData); // When input Voltage 12 V
                                                       //   nData = 0 => Startup 11.5V Shutdown 10.5V
                                                       //   nData = 1 => Startup 12V   Shutdown 11V
                                                       //   nData = 2 => Startup 12.5V Shutdown 11V
                                                       //   nData = 3 => Startup 12.5V Shutdown 11.5V
                                                       // When input Voltage 24 V
                                                       //   nData = 0 => Startup 23V Shutdown 21V
                                                       //   nData = 1 => Startup 24V Shutdown 22V
                                                       //   nData = 2 => Startup 25V Shutdown 22V
                                                       //   nData = 3 => Startup 25V Shutdown 23V
VTC1010_IO_API int  Voltage_Select_Setting_Get();      // 

VTC1010_IO_API int  Voltage_Get_Value();               // return voltage

VTC1010_IO_API void Module_Wireless_WAN_Switch(int nStatus);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Module_Wireless_WAN_Switch_Get();         // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Module_Wireless_LAN_Switch(int nStatus);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Module_Wireless_LAN_Switch_Get();         // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Module_Wireless_LAN_DIS2_L_Switch(int nStatus);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Module_Wireless_LAN_DIS2_L_Switch_Get();         // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Module_Wireless_LAN_DIS3_L_Switch(int nStatus);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Module_Wireless_LAN_DIS3_L_Switch_Get();         // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Module_GPS_Power_Switch(int nStatus);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Module_GPS_Power_Switch_Get();         // return = 0 => DISABLE, return = 1 => ENABLE

VTC1010_IO_API void SIM_CARD_Switch(int nStatus);          // nStatus = 0 => CN10 => SIM1, CN8 => SIM2, nStatus = 1 => CN10 => SIM2, CN8 => SIM1
VTC1010_IO_API int  SIM_CARD_Switch_Get();                 // return = 0 => CN10 => SIM1, CN8 => SIM2, return = 1 => CN10 => SIM2, CN8 => SIM1

VTC1010_IO_API void Wake_On_Wireless_WAN_Switch(int nStatus); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
VTC1010_IO_API int  Wake_On_Wireless_WAN_Switch_Get();        // return = 0 => DISABLE, return = 1 => ENABLE
VTC1010_IO_API void Wake_On_RTC_Switch_Setting(int nStatus, unsigned char nUserHour, unsigned char nUserMinute); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
                                                                                                                 // nUserHour => the hour value(hexadecimal)
                                                                                                                 // nUserMinute => the minute value(hexadecimal)
VTC1010_IO_API void Wake_On_RTC_Switch_Setting_Get(int *nStatus, unsigned char *nUserHour, unsigned char *nUserMinute); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
                                                                                                                        // nUserHour => the hour value(hexadecimal)
                                                                                                                        // nUserMinute => the minute value(hexadecimal)

VTC1010_IO_API void MCU_GPIO_SetGPO_Status_1(int nData);   // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API void MCU_GPIO_SetGPO_Status_2(int nData);   // nData = 0 => Low, nData = 1 => High
VTC1010_IO_API int  MCU_GPIO_ReadGPO_Status_1();           // return = 0 or 1
VTC1010_IO_API int  MCU_GPIO_ReadGPO_Status_2();           // return = 0 or 1
VTC1010_IO_API int  MCU_GPIO_ReadGPI_Status_1();           // return = 0 or 1
VTC1010_IO_API int  MCU_GPIO_ReadGPI_Status_2();           // return = 0 or 1
VTC1010_IO_API int  MCU_GPIO_ReadPANIC_Status();           // return = 0 or 1
VTC1010_IO_API void MCU_GPIO_PANIC_Status_Clear();         // Clear PANIC Status
VTC1010_IO_API void MCU_GPIO_SetLED_Status(int nStatus);   // nStatus = 0 => OFF, nStatus = 1 => ON
VTC1010_IO_API int  MCU_GPIO_SetLED_Status_Get();          // return = 0 => OFF, return = 1 => ON

VTC1010_IO_API void SerialPort_Select(int nData);          // nData = 0 => RS422. nData = 1 => RS485
VTC1010_IO_API int  SerialPort_Select_Get();               // return = 0 => RS422. return = 1 => RS485

VTC1010_IO_API void CANbus_Reset(int nData);               // nData = 0 => Don't care. nData = 1 => Reset CAN Module
VTC1010_IO_API void CANbus_Power_Reset(int nData);         // nData = 0 => Don't care. nData = 1 => Reset CAN Module Power
VTC1010_IO_API int  CANbus_Read_Data_link_detect();        // return = 0 => No data transfer. return = 1 => Data link (auto detect)
