// DialogConfigTab3.cpp : @
//

#include "stdafx.h"
#include "VTC1010_IO_Utility.h"
#include "DialogConfigTab3.h"
#include "VTC1010_IO.h"


// CDialogConfigTab3 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab3, CDialog)

CDialogConfigTab3::CDialogConfigTab3(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab3::IDD, pParent)
{

}

CDialogConfigTab3::~CDialogConfigTab3()
{
}

void CDialogConfigTab3::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_WLAN);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_WLAN_DIS2_L);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_Wireless_WAN);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_Reset_CAN_Module);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_CAN_Module_Power_Reset);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_CAN_Data_link_detect);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_MCU_GPO_Status_1);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_MCU_GPO_Status_2);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_MCU_GPO_Status_1);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_MCU_GPO_Status_2);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_MCU_GPI_Status_1);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_MCU_GPI_Status_2);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_MCU_PANIC_Status);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_WLAN);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_WLAN_DIS2_L);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_Wireless_WAN);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_WLAN_DIS3_L);
	DDX_Control(pDX, IDC_COMBO8, m_CComboBox_WLAN_DIS3_L);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab3, CDialog)
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab3::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab3::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab3::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDialogConfigTab3::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CDialogConfigTab3::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON6, &CDialogConfigTab3::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, &CDialogConfigTab3::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON8, &CDialogConfigTab3::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON11, &CDialogConfigTab3::OnBnClickedButton11)
	ON_BN_CLICKED(IDC_BUTTON12, &CDialogConfigTab3::OnBnClickedButton12)
	ON_BN_CLICKED(IDC_BUTTON13, &CDialogConfigTab3::OnBnClickedButton13)
	ON_BN_CLICKED(IDC_BUTTON14, &CDialogConfigTab3::OnBnClickedButton14)
	ON_BN_CLICKED(IDC_BUTTON9, &CDialogConfigTab3::OnBnClickedButton9)
END_MESSAGE_MAP()


// CDialogConfigTab3 TBz`

BOOL CDialogConfigTab3::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_WLAN.ResetContent();
	m_CComboBox_WLAN.InsertString(0, "OFF");
	m_CComboBox_WLAN.InsertString(1, "ON");
	m_CComboBox_WLAN.SetCurSel(1);

	m_CComboBox_WLAN_DIS2_L.ResetContent();
	m_CComboBox_WLAN_DIS2_L.InsertString(0, "OFF");
	m_CComboBox_WLAN_DIS2_L.InsertString(1, "ON");
	m_CComboBox_WLAN_DIS2_L.SetCurSel(1);

	m_CComboBox_WLAN_DIS3_L.ResetContent();
	m_CComboBox_WLAN_DIS3_L.InsertString(0, "OFF");
	m_CComboBox_WLAN_DIS3_L.InsertString(1, "ON");
	m_CComboBox_WLAN_DIS3_L.SetCurSel(1);

	m_CComboBox_Wireless_WAN.ResetContent();
	m_CComboBox_Wireless_WAN.InsertString(0, "OFF");
	m_CComboBox_Wireless_WAN.InsertString(1, "ON");
	m_CComboBox_Wireless_WAN.SetCurSel(1);

	m_CComboBox_Reset_CAN_Module.ResetContent();
	m_CComboBox_Reset_CAN_Module.InsertString(0, "Don't care");
	m_CComboBox_Reset_CAN_Module.InsertString(1, "Reset");
	m_CComboBox_Reset_CAN_Module.SetCurSel(0);

	m_CComboBox_CAN_Module_Power_Reset.ResetContent();
	m_CComboBox_CAN_Module_Power_Reset.InsertString(0, "Don't care");
	m_CComboBox_CAN_Module_Power_Reset.InsertString(1, "Reset");
	m_CComboBox_CAN_Module_Power_Reset.SetCurSel(0);

	m_CComboBox_MCU_GPO_Status_1.ResetContent();
	m_CComboBox_MCU_GPO_Status_1.InsertString(0, "MCU GPO 1 Low");
	m_CComboBox_MCU_GPO_Status_1.InsertString(1, "MCU GPO 1 High");
	m_CComboBox_MCU_GPO_Status_1.SetCurSel(0);

	m_CComboBox_MCU_GPO_Status_2.ResetContent();
	m_CComboBox_MCU_GPO_Status_2.InsertString(0, "MCU GPO 2 Low");
	m_CComboBox_MCU_GPO_Status_2.InsertString(1, "MCU GPO 2 High");
	m_CComboBox_MCU_GPO_Status_2.SetCurSel(0);

	fnModule_Wireless_LAN_Switch_Get();
	fnModule_Wireless_LAN_DIS2_L_Switch_Get();
	fnModule_Wireless_LAN_DIS3_L_Switch_Get();
	fnModule_Wireless_WAN_Switch_Get();
	fnMCU_GPIO_ReadGPO_Status_1();
	fnMCU_GPIO_ReadGPO_Status_2();

	OnBnClickedButton6();
	OnBnClickedButton11();
	OnBnClickedButton12();
	OnBnClickedButton13();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab3::OnBnClickedButton1()
{
	int nCurSel = m_CComboBox_WLAN.GetCurSel();
	Module_Wireless_LAN_Switch(nCurSel);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnModule_Wireless_LAN_Switch_Get();
}

void CDialogConfigTab3::OnBnClickedButton2()
{
	int nCurSel = m_CComboBox_WLAN_DIS2_L.GetCurSel();
	Module_Wireless_LAN_DIS2_L_Switch(nCurSel);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnModule_Wireless_LAN_DIS2_L_Switch_Get();
}

void CDialogConfigTab3::OnBnClickedButton9()
{
	int nCurSel = m_CComboBox_WLAN_DIS3_L.GetCurSel();
	Module_Wireless_LAN_DIS3_L_Switch(nCurSel);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnModule_Wireless_LAN_DIS3_L_Switch_Get();
}

void CDialogConfigTab3::OnBnClickedButton3()
{
	int nCurSel = m_CComboBox_Wireless_WAN.GetCurSel();
	Module_Wireless_WAN_Switch(nCurSel);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnModule_Wireless_WAN_Switch_Get();
}

void CDialogConfigTab3::OnBnClickedButton4()
{
	int nCurSel = m_CComboBox_Reset_CAN_Module.GetCurSel();
	CANbus_Reset(nCurSel);          // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
}

void CDialogConfigTab3::OnBnClickedButton5()
{
	int nCurSel = m_CComboBox_CAN_Module_Power_Reset.GetCurSel();
	CANbus_Power_Reset(nCurSel);          // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
}

void CDialogConfigTab3::OnBnClickedButton6()
{
	int nStatus = CANbus_Read_Data_link_detect();
	if( nStatus == 1 )
		m_CEdit_CAN_Data_link_detect.SetWindowText("Data link");
	else if( nStatus == 0 )
		m_CEdit_CAN_Data_link_detect.SetWindowText("No data transfer");
	else
		m_CEdit_CAN_Data_link_detect.SetWindowText("?");
}

void CDialogConfigTab3::OnBnClickedButton7()
{
	int nCurSel = m_CComboBox_MCU_GPO_Status_1.GetCurSel();
	MCU_GPIO_SetGPO_Status_1(nCurSel);   // nData = 0 => Low, nData = 1 => High

	fnMCU_GPIO_ReadGPO_Status_1();
}

void CDialogConfigTab3::OnBnClickedButton8()
{
	int nCurSel = m_CComboBox_MCU_GPO_Status_2.GetCurSel();
	MCU_GPIO_SetGPO_Status_2(nCurSel);   // nData = 0 => Low, nData = 1 => High

	fnMCU_GPIO_ReadGPO_Status_2();
}

void CDialogConfigTab3::OnBnClickedButton11()
{
	int nStatus = MCU_GPIO_ReadGPI_Status_1();            // return = 0 or 1
	if( nStatus == 1 )
		m_CEdit_MCU_GPI_Status_1.SetWindowText("MCU GPI-1 : High");
	else if( nStatus == 0 )
		m_CEdit_MCU_GPI_Status_1.SetWindowText("MCU GPI-1 : Low");
	else
		m_CEdit_MCU_GPI_Status_1.SetWindowText("?");
}

void CDialogConfigTab3::OnBnClickedButton12()
{
	int nStatus = MCU_GPIO_ReadGPI_Status_2();            // return = 0 or 1
	if( nStatus == 1 )
		m_CEdit_MCU_GPI_Status_2.SetWindowText("MCU GPI-2 : High");
	else if( nStatus == 0 )
		m_CEdit_MCU_GPI_Status_2.SetWindowText("MCU GPI-2 : Low");
	else
		m_CEdit_MCU_GPI_Status_2.SetWindowText("?");
}

void CDialogConfigTab3::OnBnClickedButton13()
{
	int nStatus = MCU_GPIO_ReadPANIC_Status();            // return = 0 or 1
	if( nStatus == 1 )
		m_CEdit_MCU_PANIC_Status.SetWindowText("MCU PANIC : High");
	else if( nStatus == 0 )
		m_CEdit_MCU_PANIC_Status.SetWindowText("MCU PANIC : Low");
	else
		m_CEdit_MCU_PANIC_Status.SetWindowText("?");
}

void CDialogConfigTab3::OnBnClickedButton14()
{
	MCU_GPIO_PANIC_Status_Clear();	// Clear PANIC Status
}

void CDialogConfigTab3::fnModule_Wireless_LAN_Switch_Get()
{
	int nStatus = Module_Wireless_LAN_Switch_Get();            // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_WLAN.SetWindowText("ON");
	else if( nStatus == 0 )
		m_CEdit_WLAN.SetWindowText("OFF");
	else
		m_CEdit_WLAN.SetWindowText("?");
}

void CDialogConfigTab3::fnModule_Wireless_LAN_DIS2_L_Switch_Get()
{
	int nStatus = Module_Wireless_LAN_DIS2_L_Switch_Get();     // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_WLAN_DIS2_L.SetWindowText("ON");
	else if( nStatus == 0 )
		m_CEdit_WLAN_DIS2_L.SetWindowText("OFF");
	else
		m_CEdit_WLAN_DIS2_L.SetWindowText("?");
}

void CDialogConfigTab3::fnModule_Wireless_LAN_DIS3_L_Switch_Get()
{
	int nStatus = Module_Wireless_LAN_DIS3_L_Switch_Get();     // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_WLAN_DIS3_L.SetWindowText("ON");
	else if( nStatus == 0 )
		m_CEdit_WLAN_DIS3_L.SetWindowText("OFF");
	else
		m_CEdit_WLAN_DIS3_L.SetWindowText("?");
}

void CDialogConfigTab3::fnModule_Wireless_WAN_Switch_Get()
{
	int nStatus = Module_Wireless_WAN_Switch_Get();     // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_Wireless_WAN.SetWindowText("ON");
	else if( nStatus == 0 )
		m_CEdit_Wireless_WAN.SetWindowText("OFF");
	else
		m_CEdit_Wireless_WAN.SetWindowText("?");
}

void CDialogConfigTab3::fnMCU_GPIO_ReadGPO_Status_1()
{
	int nStatus = MCU_GPIO_ReadGPO_Status_1();            // return = 0 or 1
	if( nStatus == 1 )
		m_CEdit_MCU_GPO_Status_1.SetWindowText("MCU GPO-1 : High");
	else if( nStatus == 0 )
		m_CEdit_MCU_GPO_Status_1.SetWindowText("MCU GPO-1 : Low");
	else
		m_CEdit_MCU_GPO_Status_1.SetWindowText("?");
}

void CDialogConfigTab3::fnMCU_GPIO_ReadGPO_Status_2()
{
	int nStatus = MCU_GPIO_ReadGPO_Status_2();            // return = 0 or 1
	if( nStatus == 1 )
		m_CEdit_MCU_GPO_Status_2.SetWindowText("MCU GPO-2 : High");
	else if( nStatus == 0 )
		m_CEdit_MCU_GPO_Status_2.SetWindowText("MCU GPO-2 : Low");
	else
		m_CEdit_MCU_GPO_Status_2.SetWindowText("?");
}
