// DialogConfigTab2.cpp : @
//

#include "stdafx.h"
#include "VTC1010_IO_Utility.h"
#include "DialogConfigTab2.h"
#include "VTC1010_IO.h"


// CDialogConfigTab2 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab2, CDialog)

CDialogConfigTab2::CDialogConfigTab2(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab2::IDD, pParent)
{

}

CDialogConfigTab2::~CDialogConfigTab2()
{
}

void CDialogConfigTab2::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_Wireless_WAN_Wake_up);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_RTC_Wake_up);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_Power_On_Delay);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_Power_On_Delay_Time);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_Power_Off_Delay);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_Power_Off_Delay_Time);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_InputVoltage);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_InputVoltage);
	DDX_Control(pDX, IDC_BUTTON5, m_CButton_InputVoltage);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_StartupTime_User_Hour);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_StartupTime_User_Minute);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_Wireless_WAN_Wake_up);
	DDX_Control(pDX, IDC_COMBO8, m_CComboBox_StartupTime_User_Hour);
	DDX_Control(pDX, IDC_COMBO9, m_CComboBox_StartupTime_User_Minute);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_RTC_Wake_up);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_Power_On_Delay);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_Power_On_Delay_Time);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_Power_Off_Delay);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_Power_Off_Delay_Time);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_InputVoltageSelect);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab2, CDialog)
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab2::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab2::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab2::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDialogConfigTab2::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CDialogConfigTab2::OnBnClickedButton5)
END_MESSAGE_MAP()


// CDialogConfigTab2 TBz`

BOOL CDialogConfigTab2::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_Wireless_WAN_Wake_up.ResetContent();
	m_CComboBox_Wireless_WAN_Wake_up.InsertString(0, "Disable");
	m_CComboBox_Wireless_WAN_Wake_up.InsertString(1, "Enable");
	m_CComboBox_Wireless_WAN_Wake_up.SetCurSel(0);

	m_CComboBox_RTC_Wake_up.ResetContent();
	m_CComboBox_RTC_Wake_up.InsertString(0, "Disable");
	m_CComboBox_RTC_Wake_up.InsertString(1, "Enable");
	m_CComboBox_RTC_Wake_up.SetCurSel(0);

	m_CComboBox_StartupTime_User_Hour.ResetContent();
	for ( int i=0 ; i<24 ; i++ )
	{
		CString strHour;
		strHour.Format("%d o'clock", i);
		m_CComboBox_StartupTime_User_Hour.InsertString(i, strHour);
	}
	m_CComboBox_StartupTime_User_Hour.SetCurSel(0);

	m_CComboBox_StartupTime_User_Minute.ResetContent();
	for ( int i=0 ; i<60 ; i++ )
	{
		CString strMinute;
		strMinute.Format("%d minutes", i);
		m_CComboBox_StartupTime_User_Minute.InsertString(i, strMinute);
	}
	m_CComboBox_StartupTime_User_Minute.SetCurSel(0);

	m_CComboBox_Power_On_Delay.ResetContent();
	m_CComboBox_Power_On_Delay.InsertString(0, "Disable");
	m_CComboBox_Power_On_Delay.InsertString(1, "Enable");
	m_CComboBox_Power_On_Delay.SetCurSel(0);

	m_CComboBox_Power_On_Delay_Time.ResetContent();
	m_CComboBox_Power_On_Delay_Time.InsertString(0, "10 sec");
	m_CComboBox_Power_On_Delay_Time.InsertString(1, "30 sec");
	m_CComboBox_Power_On_Delay_Time.InsertString(2, "1 min");
	m_CComboBox_Power_On_Delay_Time.InsertString(3, "5 min");
	m_CComboBox_Power_On_Delay_Time.InsertString(4, "10 min");
	m_CComboBox_Power_On_Delay_Time.InsertString(5, "15 min");
	m_CComboBox_Power_On_Delay_Time.InsertString(6, "30 min");
	m_CComboBox_Power_On_Delay_Time.InsertString(7, "1 hour");
	m_CComboBox_Power_On_Delay_Time.SetCurSel(0);

	m_CComboBox_Power_Off_Delay.ResetContent();
	m_CComboBox_Power_Off_Delay.InsertString(0, "Disable");
	m_CComboBox_Power_Off_Delay.InsertString(1, "Enable");
	m_CComboBox_Power_Off_Delay.SetCurSel(0);

	m_CComboBox_Power_Off_Delay_Time.ResetContent();
	m_CComboBox_Power_Off_Delay_Time.InsertString(0, "20 sec");
	m_CComboBox_Power_Off_Delay_Time.InsertString(1, "1 min");
	m_CComboBox_Power_Off_Delay_Time.InsertString(2, "5 min");
	m_CComboBox_Power_Off_Delay_Time.InsertString(3, "10 min");
	m_CComboBox_Power_Off_Delay_Time.InsertString(4, "30 min");
	m_CComboBox_Power_Off_Delay_Time.InsertString(5, "1 hour");
	m_CComboBox_Power_Off_Delay_Time.InsertString(6, "6 hour");
	m_CComboBox_Power_Off_Delay_Time.InsertString(7, "18 hour");
	m_CComboBox_Power_Off_Delay_Time.SetCurSel(0);

	fnWake_On_Wireless_WAN_Switch_Get();
	fnWake_On_RTC_Switch_Setting_Get();
	fnPower_On_Delay_Get();
	fnPower_On_Delay_Time_Get();
	fnPower_Off_Delay_Get();
	fnPower_Off_Delay_Time_Get();
	fnVoltage_Get();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab2::OnBnClickedButton1()
{
	int nCurSel = m_CComboBox_Wireless_WAN_Wake_up.GetCurSel();
	Wake_On_Wireless_WAN_Switch(nCurSel);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnWake_On_Wireless_WAN_Switch_Get();
}

void CDialogConfigTab2::OnBnClickedButton2()
{
	int nCurSel = m_CComboBox_RTC_Wake_up.GetCurSel();
	unsigned char nHour = m_CComboBox_StartupTime_User_Hour.GetCurSel();
	unsigned char nMinute = m_CComboBox_StartupTime_User_Minute.GetCurSel();

	Wake_On_RTC_Switch_Setting(nCurSel, nHour, nMinute); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
                                                         // nHour => the hour value(hexadecimal)
                                                         // nMinute => the minute value(hexadecimal)

	fnWake_On_RTC_Switch_Setting_Get();
}

void CDialogConfigTab2::OnBnClickedButton3()
{
	int nCurSel = m_CComboBox_Power_On_Delay.GetCurSel();
	Power_On_Delay(nCurSel); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	nCurSel = m_CComboBox_Power_On_Delay_Time.GetCurSel();
	Power_On_Delay_Time(nCurSel);

	fnPower_On_Delay_Get();
	fnPower_On_Delay_Time_Get();
}

void CDialogConfigTab2::OnBnClickedButton4()
{
	int nCurSel = m_CComboBox_Power_Off_Delay.GetCurSel();
	Power_Off_Delay(nCurSel); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	nCurSel = m_CComboBox_Power_Off_Delay_Time.GetCurSel();
	Power_Off_Delay_Time(nCurSel);

	fnPower_Off_Delay_Get();
	fnPower_Off_Delay_Time_Get();
}

void CDialogConfigTab2::OnBnClickedButton5()
{
	int nCurSel = m_CComboBox_InputVoltage.GetCurSel();
	Voltage_Select_Setting(nCurSel);
}

void CDialogConfigTab2::fnWake_On_Wireless_WAN_Switch_Get()
{
	int nStatus = Wake_On_Wireless_WAN_Switch_Get();            // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_Wireless_WAN_Wake_up.SetWindowText("Enable");
	else if( nStatus == 0 )
		m_CEdit_Wireless_WAN_Wake_up.SetWindowText("Disable");
	else
		m_CEdit_Wireless_WAN_Wake_up.SetWindowText("?");
}

void CDialogConfigTab2::fnWake_On_RTC_Switch_Setting_Get()
{
	int nStatus = 0;
	unsigned char nHour = 0;
	unsigned char nMinute = 0;
	Wake_On_RTC_Switch_Setting_Get(&nStatus, &nHour, &nMinute); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
                                                                // nHour => the hour value(hexadecimal)
                                                                // nMinute => the minute value(hexadecimal)
	if( nStatus == 1 )
		m_CEdit_RTC_Wake_up.SetWindowText("Enable");
	else if( nStatus == 0 )
		m_CEdit_RTC_Wake_up.SetWindowText("Disable");
	else
		m_CEdit_RTC_Wake_up.SetWindowText("?");

	CString strHour;
	strHour.Format("%d o'clock", nHour);
	m_CEdit_StartupTime_User_Hour.SetWindowText(strHour);

	CString strMinute;
	strMinute.Format("%d minutes", nMinute);
	m_CEdit_StartupTime_User_Minute.SetWindowText(strMinute);
}

void CDialogConfigTab2::fnPower_On_Delay_Get()
{
	int nStatus = Power_On_Delay_Get();            // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_Power_On_Delay.SetWindowText("Enable");
	else if( nStatus == 0 )
		m_CEdit_Power_On_Delay.SetWindowText("Disable");
	else
		m_CEdit_Power_On_Delay.SetWindowText("?");
}

void CDialogConfigTab2::fnPower_On_Delay_Time_Get()
{
	int nStatus = Power_On_Delay_Time_Get();
	switch(nStatus)
	{
	case 0: m_CEdit_Power_On_Delay_Time.SetWindowText("10 sec"); break;
	case 1: m_CEdit_Power_On_Delay_Time.SetWindowText("30 sec"); break;
	case 2: m_CEdit_Power_On_Delay_Time.SetWindowText("1 min"); break;
	case 3: m_CEdit_Power_On_Delay_Time.SetWindowText("5 min"); break;
	case 4: m_CEdit_Power_On_Delay_Time.SetWindowText("10 min"); break;
	case 5: m_CEdit_Power_On_Delay_Time.SetWindowText("15 min"); break;
	case 6: m_CEdit_Power_On_Delay_Time.SetWindowText("30 min"); break;
	case 7: m_CEdit_Power_On_Delay_Time.SetWindowText("1 hour"); break;
	default: m_CEdit_Power_On_Delay_Time.SetWindowText("?"); break;
	}
}

void CDialogConfigTab2::fnPower_Off_Delay_Get()
{
	int nStatus = Power_Off_Delay_Get();            // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_Power_Off_Delay.SetWindowText("Enable");
	else if( nStatus == 0 )
		m_CEdit_Power_Off_Delay.SetWindowText("Disable");
	else
		m_CEdit_Power_Off_Delay.SetWindowText("?");
}

void CDialogConfigTab2::fnPower_Off_Delay_Time_Get()
{
	int nStatus = Power_Off_Delay_Time_Get();
	switch(nStatus)
	{
	case 0: m_CEdit_Power_Off_Delay_Time.SetWindowText("20 sec"); break;
	case 1: m_CEdit_Power_Off_Delay_Time.SetWindowText("1 min"); break;
	case 2: m_CEdit_Power_Off_Delay_Time.SetWindowText("5 min"); break;
	case 3: m_CEdit_Power_Off_Delay_Time.SetWindowText("10 min"); break;
	case 4: m_CEdit_Power_Off_Delay_Time.SetWindowText("30 min"); break;
	case 5: m_CEdit_Power_Off_Delay_Time.SetWindowText("1 hour"); break;
	case 6: m_CEdit_Power_Off_Delay_Time.SetWindowText("6 hour"); break;
	case 7: m_CEdit_Power_Off_Delay_Time.SetWindowText("18 hour"); break;
	default: m_CEdit_Power_Off_Delay_Time.SetWindowText("?"); break;
	}
}

void CDialogConfigTab2::fnVoltage_Get()
{
	int nVol = Voltage_Get();

	switch (nVol)
	{
	case 0:
		m_CEdit_InputVoltage.SetWindowText("9V~36V");
		m_CComboBox_InputVoltage.EnableWindow(FALSE);
		m_CButton_InputVoltage.EnableWindow(FALSE);
		break;
	case 1:
		m_CEdit_InputVoltage.SetWindowText("9V~36V");
		m_CComboBox_InputVoltage.EnableWindow(FALSE);
		m_CButton_InputVoltage.EnableWindow(FALSE);
		break;
	case 2:
		m_CEdit_InputVoltage.SetWindowText("24V");
		m_CComboBox_InputVoltage.ResetContent();
		m_CComboBox_InputVoltage.InsertString(0, "23V 21V");
		m_CComboBox_InputVoltage.InsertString(1, "24V 22V");
		m_CComboBox_InputVoltage.InsertString(2, "25V 22V");
		m_CComboBox_InputVoltage.InsertString(3, "25V 23V");
		m_CComboBox_InputVoltage.SetCurSel(0);
		break;
	case 3:
		m_CEdit_InputVoltage.SetWindowText("12V");
		m_CComboBox_InputVoltage.ResetContent();
		m_CComboBox_InputVoltage.InsertString(0, "11.5V 10.5V");
		m_CComboBox_InputVoltage.InsertString(1, "12.0V 11.0V");
		m_CComboBox_InputVoltage.InsertString(2, "12.5V 11.0V");
		m_CComboBox_InputVoltage.InsertString(3, "12.5V 11.5V");
		m_CComboBox_InputVoltage.SetCurSel(0);
		break;
	default:
		m_CEdit_InputVoltage.SetWindowText("Unknown");
		m_CComboBox_InputVoltage.EnableWindow(FALSE);
		m_CButton_InputVoltage.EnableWindow(FALSE);
		break;
	}

	switch (nVol)
	{
	case 0:
		m_CEdit_InputVoltageSelect.SetWindowText("9V~36V");
		break;
	case 1:
		m_CEdit_InputVoltageSelect.SetWindowText("9V~36V");
		break;
	case 2:
		{
			int nSelect1 = Voltage_Select_Setting_Get();
			switch(nSelect1)
			{
			case 0: m_CEdit_InputVoltageSelect.SetWindowText("23V 21V"); break;
			case 1: m_CEdit_InputVoltageSelect.SetWindowText("24V 22V"); break;
			case 2: m_CEdit_InputVoltageSelect.SetWindowText("25V 22V"); break;
			case 3: m_CEdit_InputVoltageSelect.SetWindowText("25V 23V"); break;
			default: m_CEdit_InputVoltageSelect.SetWindowText("Unknown"); break;
			}
		}
		break;
	case 3:
		{
			int nSelect2 = Voltage_Select_Setting_Get();
			switch(nSelect2)
			{
			case 0: m_CEdit_InputVoltageSelect.SetWindowText("11.5V 10.5V"); break;
			case 1: m_CEdit_InputVoltageSelect.SetWindowText("12.0V 11.0V"); break;
			case 2: m_CEdit_InputVoltageSelect.SetWindowText("12.5V 11.0V"); break;
			case 3: m_CEdit_InputVoltageSelect.SetWindowText("12.5V 11.5V"); break;
			default: m_CEdit_InputVoltageSelect.SetWindowText("Unknown"); break;
			}
		}
		break;
	default:
		m_CEdit_InputVoltageSelect.SetWindowText("Unknown");
		break;
	}
}
