// DialogConfigTab1.cpp : @
//

#include "stdafx.h"
#include "VTC1010_IO_Utility.h"
#include "DialogConfigTab1.h"
#include "VTC1010_IO.h"


// CDialogConfigTab1 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab1, CDialog)

CDialogConfigTab1::CDialogConfigTab1(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab1::IDD, pParent)
{

}

CDialogConfigTab1::~CDialogConfigTab1()
{
}

void CDialogConfigTab1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_Ignition);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_Battery);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_WDT);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_WDT_Time);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_InputVoltage_Value);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_SIM_CARD);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_SerialPort_Select);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_EXTERNAL_12V);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_GPS_POWER);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_GPIO_LED);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_EXTERNAL_12V);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_WDT);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_WDT_Time);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_SIM_CARD);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_SerialPort_Select);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_GPS_POWER);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_GPIO_LED);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab1, CDialog)
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab1::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab1::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab1::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDialogConfigTab1::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CDialogConfigTab1::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON6, &CDialogConfigTab1::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON7, &CDialogConfigTab1::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON8, &CDialogConfigTab1::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON9, &CDialogConfigTab1::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON10, &CDialogConfigTab1::OnBnClickedButton10)
END_MESSAGE_MAP()


// CDialogConfigTab1 TBz`

BOOL CDialogConfigTab1::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_WDT.ResetContent();
	m_CComboBox_WDT.InsertString(0, "Disable");
	m_CComboBox_WDT.InsertString(1, "Enable");
	m_CComboBox_WDT.SetCurSel(0);

	m_CComboBox_WDT_Time.ResetContent();
	m_CComboBox_WDT_Time.InsertString(0, "1 sec");
	m_CComboBox_WDT_Time.InsertString(1, "2 sec");
	m_CComboBox_WDT_Time.InsertString(2, "4 sec");
	m_CComboBox_WDT_Time.InsertString(3, "8 sec");
	m_CComboBox_WDT_Time.InsertString(4, "16 sec");
	m_CComboBox_WDT_Time.InsertString(5, "32 sec");
	m_CComboBox_WDT_Time.InsertString(6, "64 sec");
	m_CComboBox_WDT_Time.InsertString(7, "128 sec");
	m_CComboBox_WDT_Time.InsertString(8, "256 sec");
	m_CComboBox_WDT_Time.SetCurSel(0);

	m_CComboBox_SIM_CARD.ResetContent();
	m_CComboBox_SIM_CARD.InsertString(0, "CN10 => SIM1, CN8 => SIM2");
	m_CComboBox_SIM_CARD.InsertString(1, "CN10 => SIM2, CN8 => SIM1");
	m_CComboBox_SIM_CARD.SetCurSel(0);

	m_CComboBox_SerialPort_Select.ResetContent();
	m_CComboBox_SerialPort_Select.InsertString(0, "RS-422");
	m_CComboBox_SerialPort_Select.InsertString(1, "RS-485");
	m_CComboBox_SerialPort_Select.SetCurSel(1);

	m_CComboBox_EXTERNAL_12V.ResetContent();
	m_CComboBox_EXTERNAL_12V.InsertString(0, "Disable");
	m_CComboBox_EXTERNAL_12V.InsertString(1, "Enable");
	m_CComboBox_EXTERNAL_12V.SetCurSel(1);

	m_CComboBox_GPS_POWER.ResetContent();
	m_CComboBox_GPS_POWER.InsertString(0, "OFF");
	m_CComboBox_GPS_POWER.InsertString(1, "ON");
	m_CComboBox_GPS_POWER.SetCurSel(1);

	m_CComboBox_GPIO_LED.ResetContent();
	m_CComboBox_GPIO_LED.InsertString(0, "LED OFF");
	m_CComboBox_GPIO_LED.InsertString(1, "LED ON");
	m_CComboBox_GPIO_LED.SetCurSel(0);

	OnBnClickedButton1();
	OnBnClickedButton5();
	OnBnClickedButton2();

	fnEXTERNAL_12V_Get();
	fnWDT_Switch_Get();
	fnWDT_Time_Setting_Get();
	fnSIM_CARD_Switch_Get();
	fnSerialPort_Select_Get();
	fnModule_GPS_Power_Switch_Get();
	fnMCU_GPIO_SetLED_Status_Get();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab1::OnBnClickedButton1()
{
	int nStatus = LED_Control_GetIgnition(); // return = 0 => OFF, return = 1 => ON
	if( nStatus == 1 )
		m_CEdit_Ignition.SetWindowText("ON");
	else if( nStatus == 0 )
		m_CEdit_Ignition.SetWindowText("OFF");
	else
		m_CEdit_Ignition.SetWindowText("?");
}

void CDialogConfigTab1::OnBnClickedButton2()
{
	int nStatus = Car_Battery_GetStatus(); // return = 0 => Low voltage, return = 1 => OK
	if( nStatus == 1 )
		m_CEdit_Battery.SetWindowText("OK");
	else if ( nStatus == 0 )
		m_CEdit_Battery.SetWindowText("Low voltage");
	else
		m_CEdit_Battery.SetWindowText("?");
}

void CDialogConfigTab1::OnBnClickedButton3()
{
	int nCurSel = m_CComboBox_WDT_Time.GetCurSel();
	WDT_Time_Setting(nCurSel);

	nCurSel = m_CComboBox_WDT.GetCurSel();
	WDT_Switch(nCurSel); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnWDT_Switch_Get();
	fnWDT_Time_Setting_Get();
}

void CDialogConfigTab1::OnBnClickedButton4()
{
	WDT_Clear_Timer(); // clear WDT timer
}

void CDialogConfigTab1::OnBnClickedButton5()
{
	m_CEdit_InputVoltage_Value.SetWindowText("");

	int nVoltage = Voltage_Get_Value();                   // return voltage
	if( -1 == nVoltage )
		m_CEdit_InputVoltage_Value.SetWindowText("?");
	else
	{
		double fVoltage = (double)nVoltage/1000;
		CString strVoltage;
		strVoltage.Format("%2.1f V", fVoltage); 
		m_CEdit_InputVoltage_Value.SetWindowText(strVoltage);
	}
}

void CDialogConfigTab1::OnBnClickedButton6()
{
	int nCurSel = m_CComboBox_SIM_CARD.GetCurSel();
	SIM_CARD_Switch(nCurSel);  // nStatus = 0 => CN10 => SIM1, CN8 => SIM2, 
	                           // nStatus = 1 => CN10 => SIM2, CN8 => SIM1

	fnSIM_CARD_Switch_Get();
}

void CDialogConfigTab1::OnBnClickedButton7()
{
	int nCurSel = m_CComboBox_SerialPort_Select.GetCurSel();
	SerialPort_Select(nCurSel);          // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnSerialPort_Select_Get();
}

void CDialogConfigTab1::OnBnClickedButton8()
{
	int nCurSel = m_CComboBox_EXTERNAL_12V.GetCurSel();
	EXTERNAL_12V_Power(nCurSel); // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE
	fnEXTERNAL_12V_Get();
}

void CDialogConfigTab1::OnBnClickedButton9()
{
	int nCurSel = m_CComboBox_GPS_POWER.GetCurSel();
	Module_GPS_Power_Switch(nCurSel);  // nStatus = 0 => DISABLE, nStatus = 1 => ENABLE

	fnModule_GPS_Power_Switch_Get();
}

void CDialogConfigTab1::OnBnClickedButton10()
{
	int nCurSel = m_CComboBox_GPIO_LED.GetCurSel();
	MCU_GPIO_SetLED_Status(nCurSel);          // nStatus = 0 => OFF, nStatus = 1 => ON

	fnMCU_GPIO_SetLED_Status_Get();
}

void CDialogConfigTab1::fnEXTERNAL_12V_Get()
{
	int nStatus = EXTERNAL_12V_Power_Get(); // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_EXTERNAL_12V.SetWindowText("Enable");
	else if( nStatus == 0 )
		m_CEdit_EXTERNAL_12V.SetWindowText("Disable");
	else
		m_CEdit_EXTERNAL_12V.SetWindowText("?");
}

void CDialogConfigTab1::fnWDT_Switch_Get()
{
	int nStatus = WDT_Switch_Get();                  // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_WDT.SetWindowText("Enable");
	else if( nStatus == 0 )
		m_CEdit_WDT.SetWindowText("Disable");
	else
		m_CEdit_WDT.SetWindowText("?");
}

void CDialogConfigTab1::fnWDT_Time_Setting_Get()
{
	int nStatus = WDT_Time_Setting_Get();            // return timeout 
	switch(nStatus)
	{
	case 0: m_CEdit_WDT_Time.SetWindowText("1 sec"); break;
	case 1: m_CEdit_WDT_Time.SetWindowText("2 sec"); break;
	case 2: m_CEdit_WDT_Time.SetWindowText("4 sec"); break;
	case 3: m_CEdit_WDT_Time.SetWindowText("8 sec"); break;
	case 4: m_CEdit_WDT_Time.SetWindowText("16 sec"); break;
	case 5: m_CEdit_WDT_Time.SetWindowText("32 sec"); break;
	case 6: m_CEdit_WDT_Time.SetWindowText("64 sec"); break;
	case 7: m_CEdit_WDT_Time.SetWindowText("128 sec"); break;
	case 8: m_CEdit_WDT_Time.SetWindowText("256 sec"); break;
	default: m_CEdit_WDT_Time.SetWindowText(""); break;
	}
}

void CDialogConfigTab1::fnSIM_CARD_Switch_Get()
{
	int nStatus = SIM_CARD_Switch_Get(); // return = 0 => RS422. return = 1 => RS485
	if( nStatus == 1 )
		m_CEdit_SIM_CARD.SetWindowText("CN10 => SIM2, CN8 => SIM1");
	else if( nStatus == 0 )
		m_CEdit_SIM_CARD.SetWindowText("CN10 => SIM1, CN8 => SIM2");
	else
		m_CEdit_SIM_CARD.SetWindowText("?");
}

void CDialogConfigTab1::fnSerialPort_Select_Get()
{
	int nStatus = SerialPort_Select_Get(); // return = 0 => RS422. return = 1 => RS485
	if( nStatus == 1 )
		m_CEdit_SerialPort_Select.SetWindowText("RS-485");
	else if( nStatus == 0 )
		m_CEdit_SerialPort_Select.SetWindowText("RS-422");
	else
		m_CEdit_SerialPort_Select.SetWindowText("?");
}

void CDialogConfigTab1::fnModule_GPS_Power_Switch_Get()
{
	int nStatus = Module_GPS_Power_Switch_Get(); // return = 0 => DISABLE, return = 1 => ENABLE
	if( nStatus == 1 )
		m_CEdit_GPS_POWER.SetWindowText("ON");
	else if( nStatus == 0 )
		m_CEdit_GPS_POWER.SetWindowText("OFF");
	else
		m_CEdit_GPS_POWER.SetWindowText("?");
}

void CDialogConfigTab1::fnMCU_GPIO_SetLED_Status_Get()
{
	int nStatus = MCU_GPIO_SetLED_Status_Get(); // return = 0 => OFF, return = 1 => ON
	if( nStatus == 1 )
		m_CEdit_GPIO_LED.SetWindowText("LED ON");
	else if( nStatus == 0 )
		m_CEdit_GPIO_LED.SetWindowText("LED OFF");
	else
		m_CEdit_GPIO_LED.SetWindowText("?");
}
