
// VTK_RELAY_01_UtilityDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VTK_RELAY_01_Utility.h"
#include "VTK_RELAY_01_UtilityDlg.h"
#include "VTK_RELAY_01.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


CUIntArray ports;


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CVTK_RELAY_01_UtilityDlg dialog




CVTK_RELAY_01_UtilityDlg::CVTK_RELAY_01_UtilityDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVTK_RELAY_01_UtilityDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVTK_RELAY_01_UtilityDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_Message);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_MCUversion);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_SupplyVoltage);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_GPI12Level);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_GPI34Level);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_GPI12Level);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_GPI34Level);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_GPO12PullUp);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_GPO34PullUp);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_GPI1);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_GPI2);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_GPI3);
	DDX_Control(pDX, IDC_EDIT11, m_CEdit_GPI4);
	DDX_Control(pDX, IDC_EDIT12, m_CEdit_GPO1);
	DDX_Control(pDX, IDC_EDIT13, m_CEdit_GPO2);
	DDX_Control(pDX, IDC_EDIT14, m_CEdit_GPO3);
	DDX_Control(pDX, IDC_EDIT15, m_CEdit_GPO4);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_GPO1);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_GPO2);
	DDX_Control(pDX, IDC_COMBO8, m_CComboBox_GPO3);
	DDX_Control(pDX, IDC_COMBO9, m_CComboBox_GPO4);
	DDX_Control(pDX, IDC_EDIT16, m_CEdit_Relay1);
	DDX_Control(pDX, IDC_EDIT17, m_CEdit_Relay2);
	DDX_Control(pDX, IDC_EDIT18, m_CEdit_Relay3);
	DDX_Control(pDX, IDC_EDIT19, m_CEdit_Relay4);
	DDX_Control(pDX, IDC_COMBO10, m_CComboBox_Relay1);
	DDX_Control(pDX, IDC_COMBO11, m_CComboBox_Relay2);
	DDX_Control(pDX, IDC_COMBO12, m_CComboBox_Relay3);
	DDX_Control(pDX, IDC_COMBO13, m_CComboBox_Relay4);
	DDX_Control(pDX, IDC_EDIT20, m_CEdit_InputCurrent);
	DDX_Control(pDX, IDC_EDIT21, m_CEdit_InputVoltage);
	DDX_Control(pDX, IDC_EDIT22, m_CEdit_InputFrequency);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_GPO12PullUp);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_GPO34PullUp);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_PortNum);
	DDX_Control(pDX, IDC_EDIT23, m_CEdit_Ignition);
}

BEGIN_MESSAGE_MAP(CVTK_RELAY_01_UtilityDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_CLOSE()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON7, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton7)
	ON_BN_CLICKED(IDC_BUTTON6, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton6)
	ON_BN_CLICKED(IDC_BUTTON8, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton8)
	ON_BN_CLICKED(IDC_BUTTON9, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON10, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton10)
	ON_BN_CLICKED(IDC_BUTTON11, &CVTK_RELAY_01_UtilityDlg::OnBnClickedButton11)
END_MESSAGE_MAP()


// CVTK_RELAY_01_UtilityDlg message handlers

BOOL CVTK_RELAY_01_UtilityDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	ports.RemoveAll();

	for (UINT i=1; i<256; i++)
	{
		//Form the Raw device name
		CString sPort;
		sPort.Format(TEXT("COM%d"), i);
		
		COMMCONFIG cc;
		DWORD dwSize = sizeof(COMMCONFIG);
		if (GetDefaultCommConfig(sPort, &cc, &dwSize))
		{
			ports.Add(i);
		}
	}

	int nSize = ports.GetSize();
	if( nSize > 0 )
	{
		m_CComboBox_PortNum.ResetContent();
		for ( int i=0 ; i<nSize ; i++ )
		{
			CString PortString;
			PortString.Format(TEXT("COM%d"), ports.GetAt(i));
			m_CComboBox_PortNum.InsertString(i, PortString);
		}
		m_CComboBox_PortNum.SetCurSel(0);
	}
	else
	{
		ports.RemoveAll();
		m_CComboBox_PortNum.ResetContent();
		for ( int i=0 ; i<9 ; i++ )
		{
			CString PortString;
			PortString.Format(TEXT("COM%d"),i+1);
			m_CComboBox_PortNum.InsertString(i, PortString);
			ports.Add(i+1);
		}
		m_CComboBox_PortNum.SetCurSel(0);
	}

	m_CComboBox_GPI12Level.ResetContent();
	m_CComboBox_GPI12Level.InsertString(0, TEXT("GPI Active Low"));
	m_CComboBox_GPI12Level.InsertString(1, TEXT("GPI Active High"));
	m_CComboBox_GPI12Level.SetCurSel(0);

	m_CComboBox_GPI34Level.ResetContent();
	m_CComboBox_GPI34Level.InsertString(0, TEXT("GPI Active Low"));
	m_CComboBox_GPI34Level.InsertString(1, TEXT("GPI Active High"));
	m_CComboBox_GPI34Level.SetCurSel(0);

	m_CComboBox_GPO12PullUp.ResetContent();
	m_CComboBox_GPO12PullUp.InsertString(0, TEXT("Internal"));
	m_CComboBox_GPO12PullUp.InsertString(1, TEXT("External"));
	m_CComboBox_GPO12PullUp.SetCurSel(0);

	m_CComboBox_GPO34PullUp.ResetContent();
	m_CComboBox_GPO34PullUp.InsertString(0, TEXT("Internal"));
	m_CComboBox_GPO34PullUp.InsertString(1, TEXT("External"));
	m_CComboBox_GPO34PullUp.SetCurSel(0);

	m_CComboBox_GPO1.ResetContent();
	m_CComboBox_GPO1.InsertString(0, TEXT("Low"));
	m_CComboBox_GPO1.InsertString(1, TEXT("High"));
	m_CComboBox_GPO1.SetCurSel(1);

	m_CComboBox_GPO2.ResetContent();
	m_CComboBox_GPO2.InsertString(0, TEXT("Low"));
	m_CComboBox_GPO2.InsertString(1, TEXT("High"));
	m_CComboBox_GPO2.SetCurSel(1);

	m_CComboBox_GPO3.ResetContent();
	m_CComboBox_GPO3.InsertString(0, TEXT("Low"));
	m_CComboBox_GPO3.InsertString(1, TEXT("High"));
	m_CComboBox_GPO3.SetCurSel(1);

	m_CComboBox_GPO4.ResetContent();
	m_CComboBox_GPO4.InsertString(0, TEXT("Low"));
	m_CComboBox_GPO4.InsertString(1, TEXT("High"));
	m_CComboBox_GPO4.SetCurSel(1);

	m_CComboBox_Relay1.ResetContent();
	m_CComboBox_Relay1.InsertString(0, TEXT("OFF"));
	m_CComboBox_Relay1.InsertString(1, TEXT("ON"));
	m_CComboBox_Relay1.SetCurSel(0);

	m_CComboBox_Relay2.ResetContent();
	m_CComboBox_Relay2.InsertString(0, TEXT("OFF"));
	m_CComboBox_Relay2.InsertString(1, TEXT("ON"));
	m_CComboBox_Relay2.SetCurSel(0);

	m_CComboBox_Relay3.ResetContent();
	m_CComboBox_Relay3.InsertString(0, TEXT("OFF"));
	m_CComboBox_Relay3.InsertString(1, TEXT("ON"));
	m_CComboBox_Relay3.SetCurSel(0);

	m_CComboBox_Relay4.ResetContent();
	m_CComboBox_Relay4.InsertString(0, TEXT("OFF"));
	m_CComboBox_Relay4.InsertString(1, TEXT("ON"));
	m_CComboBox_Relay4.SetCurSel(0);


	int nMajorVersion = 0;
	int nMinorVersion = 0;
	ExIO_Get_DLL_Version(&nMajorVersion, &nMinorVersion);
	CString DLLVersion;
	DLLVersion.Format(TEXT("DLL ver : %d.%d"), nMajorVersion, nMinorVersion);
	m_CEdit_Message.SetWindowText(DLLVersion);

	DisableButtonWhenClose();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVTK_RELAY_01_UtilityDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVTK_RELAY_01_UtilityDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVTK_RELAY_01_UtilityDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CVTK_RELAY_01_UtilityDlg::OnClose()
{
	OnBnClickedButton2();

	CDialog::OnClose();
}

void CVTK_RELAY_01_UtilityDlg::OnTimer(UINT_PTR nIDEvent)
{
	if( 1 == nIDEvent )
	{
		KillTimer(1);

		switch( m_nStep )
		{
		case 0: fnGetMCUVersion();		m_nStep++; break;
		case 1: fnGetIgnitionStatus();	m_nStep++; break;
		case 2: fnGetSupplyVoltage();	m_nStep++; break;
		case 3: fnGetExtGPILevel();		m_nStep++; break;
		case 4: fnGetExtGPOPullUp();	m_nStep++; break;
		case 5: fnGetExtGPIStatus();	m_nStep++; break;
		case 6: fnGetExtGPOStatus();	m_nStep++; break;
		case 7: fnGetRelayStatus();		m_nStep++; break;
		case 8: fnGetInputCurrent();	m_nStep++; break;
		case 9: fnGetInputVoltage();	m_nStep++; break;
		case 10: fnGetInputFrequency();	m_nStep++; break;
		default: break;
		}

		if( m_nStep < 11 )
			SetTimer(1, 100, NULL);
		else
			SetTimer(2, 0, NULL);
	}

	if( 2 == nIDEvent )
	{
		KillTimer(2);

		static unsigned int nSystemCount = 0;

		switch(nSystemCount%6)
		{
		case 0: fnGetIgnitionStatus(); break;
		case 1: fnGetSupplyVoltage(); break;
		case 2: fnGetExtGPIStatus(); break;
		case 3: fnGetInputCurrent(); break;
		case 4: fnGetInputVoltage(); break;
		case 5: fnGetInputFrequency(); break;
		}

		nSystemCount++;

		SetTimer(2, 200, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}

void CVTK_RELAY_01_UtilityDlg::fnGetMCUVersion()
{
	int nMCUVersion = 0;
	int nResult = ExIO_GetMCUVersion(&nMCUVersion);
	if( nResult == 1 )
	{
		CString strMCUVersion;
		strMCUVersion.Format(TEXT("VK50_R%02d"), nMCUVersion);
		m_CEdit_MCUversion.SetWindowText(strMCUVersion);
	}
	else
	{
		m_CEdit_MCUversion.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetIgnitionStatus()
{
	int nIgnitionStatus = 0;
	int nResult = ExIO_GetIgnitionStatus(&nIgnitionStatus);
	if( nResult == 1 )
	{
		CString strIgnition;
		switch(nIgnitionStatus)
		{
		case 0: strIgnition = TEXT("OFF"); break;
		case 1: strIgnition = TEXT("ON"); break;
		default: strIgnition = TEXT("Undefined"); break;
		}
		m_CEdit_Ignition.SetWindowText(strIgnition);
	}
	else
	{
		m_CEdit_Ignition.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetSupplyVoltage()
{
	int nSupplyVoltage = 0;
	int nResult = ExIO_GetSupplyVoltage(&nSupplyVoltage);
	if( nResult == 1 )
	{
		double fVoltage = (double)nSupplyVoltage/1000;
		CString strSupplyVoltage;
		strSupplyVoltage.Format(TEXT("%2.1f V"), fVoltage); 
		m_CEdit_SupplyVoltage.SetWindowText(strSupplyVoltage);
	}
	else
	{
		m_CEdit_SupplyVoltage.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetExtGPILevel()
{
	int nGPI12 = 0;
	int nGPI34 = 0;

	int nResult = ExIO_GetExtGPILevel(&nGPI12, &nGPI34);
	if( nResult == 1 )
	{
		switch(nGPI12)
		{
		case 0: m_CEdit_GPI12Level.SetWindowText(TEXT("GPI Active Low")); break;
		case 1: m_CEdit_GPI12Level.SetWindowText(TEXT("GPI Active High")); break;
		default: m_CEdit_GPI12Level.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPI34)
		{
		case 0: m_CEdit_GPI34Level.SetWindowText(TEXT("GPI Active Low")); break;
		case 1: m_CEdit_GPI34Level.SetWindowText(TEXT("GPI Active High")); break;
		default: m_CEdit_GPI34Level.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_GPI12Level.SetWindowText(TEXT("?"));
		m_CEdit_GPI34Level.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetExtGPOPullUp()
{
	int nGPO12 = 0;
	int nGPO34 = 0;

	int nResult = ExIO_GetExtGPOPullUp(&nGPO12, &nGPO34);
	if( nResult == 1 )
	{
		switch(nGPO12)
		{
		case 0: m_CEdit_GPO12PullUp.SetWindowText(TEXT("Internal")); break;
		case 1: m_CEdit_GPO12PullUp.SetWindowText(TEXT("External")); break;
		default: m_CEdit_GPO12PullUp.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPO34)
		{
		case 0: m_CEdit_GPO34PullUp.SetWindowText(TEXT("Internal")); break;
		case 1: m_CEdit_GPO34PullUp.SetWindowText(TEXT("External")); break;
		default: m_CEdit_GPO34PullUp.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_GPO12PullUp.SetWindowText(TEXT("?"));
		m_CEdit_GPO34PullUp.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetExtGPIStatus()
{
	int nGPI1;
	int nGPI2;
	int nGPI3;
	int nGPI4;

	int nResult = ExIO_GetExtGPIStatus(&nGPI1, &nGPI2, &nGPI3, &nGPI4);
	if( nResult == 1 )
	{
		switch(nGPI1)
		{
		case 0: m_CEdit_GPI1.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPI1.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPI1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPI2)
		{
		case 0: m_CEdit_GPI2.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPI2.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPI2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPI3)
		{
		case 0: m_CEdit_GPI3.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPI3.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPI3.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPI4)
		{
		case 0: m_CEdit_GPI4.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPI4.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPI4.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_GPI1.SetWindowText(TEXT("?"));
		m_CEdit_GPI2.SetWindowText(TEXT("?"));
		m_CEdit_GPI3.SetWindowText(TEXT("?"));
		m_CEdit_GPI4.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetExtGPOStatus()
{
	int nGPO1;
	int nGPO2;
	int nGPO3;
	int nGPO4;

	int nResult = ExIO_GetExtGPOStatus(&nGPO1, &nGPO2, &nGPO3, &nGPO4);
	if( nResult == 1 )
	{
		switch(nGPO1)
		{
		case 0: m_CEdit_GPO1.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPO1.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPO1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPO2)
		{
		case 0: m_CEdit_GPO2.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPO2.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPO2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPO3)
		{
		case 0: m_CEdit_GPO3.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPO3.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPO3.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nGPO4)
		{
		case 0: m_CEdit_GPO4.SetWindowText(TEXT("Low")); break;
		case 1: m_CEdit_GPO4.SetWindowText(TEXT("High")); break;
		default: m_CEdit_GPO4.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_GPO1.SetWindowText(TEXT("?"));
		m_CEdit_GPO2.SetWindowText(TEXT("?"));
		m_CEdit_GPO3.SetWindowText(TEXT("?"));
		m_CEdit_GPO4.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetRelayStatus()
{
	int nRelay1;
	int nRelay2;
	int nRelay3;
	int nRelay4;

	int nResult = ExIO_GetRelayStatus(&nRelay1, &nRelay2, &nRelay3, &nRelay4);
	if( nResult == 1 )
	{
		switch(nRelay1)
		{
		case 0: m_CEdit_Relay1.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_Relay1.SetWindowText(TEXT("ON")); break;
		default: m_CEdit_Relay1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nRelay2)
		{
		case 0: m_CEdit_Relay2.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_Relay2.SetWindowText(TEXT("ON")); break;
		default: m_CEdit_Relay2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nRelay3)
		{
		case 0: m_CEdit_Relay3.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_Relay3.SetWindowText(TEXT("ON")); break;
		default: m_CEdit_Relay3.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nRelay4)
		{
		case 0: m_CEdit_Relay4.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_Relay4.SetWindowText(TEXT("ON")); break;
		default: m_CEdit_Relay4.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_Relay1.SetWindowText(TEXT("?"));
		m_CEdit_Relay2.SetWindowText(TEXT("?"));
		m_CEdit_Relay3.SetWindowText(TEXT("?"));
		m_CEdit_Relay4.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetInputCurrent()
{
	int nInputCurrent;
	int nResult = ExIO_GetInputCurrent(&nInputCurrent);
	if( nResult == 1 )
	{
		CString strInputCurrent;
		strInputCurrent.Format(TEXT("%d mA"), nInputCurrent);
		m_CEdit_InputCurrent.SetWindowText(strInputCurrent);
	}
	else
	{
		m_CEdit_InputCurrent.SetWindowText(TEXT("? mA"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetInputVoltage()
{
	int nInputVoltage = 0;
	int nResult = ExIO_GetInputVoltage(&nInputVoltage);
	if( nResult == 1 )
	{
		double fVoltage = (double)nInputVoltage/1000;
		CString strVoltage;
		strVoltage.Format(TEXT("%2.1f V"), fVoltage); 
		m_CEdit_InputVoltage.SetWindowText(strVoltage);
	}
	else
	{
		m_CEdit_InputVoltage.SetWindowText(TEXT("?"));
	}
}

void CVTK_RELAY_01_UtilityDlg::fnGetInputFrequency()
{
	int nInputFrequency;
	int nResult = ExIO_GetInputFrequency(&nInputFrequency);
	if( nResult == 1 )
	{
		CString strInputFrequency;
		strInputFrequency.Format(TEXT("%d Hz"), nInputFrequency);
		m_CEdit_InputFrequency.SetWindowText(strInputFrequency);
	}
	else
	{
		m_CEdit_InputFrequency.SetWindowText(TEXT("? Hz"));
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton1()
{
	unsigned int nPortSelect = m_CComboBox_PortNum.GetCurSel();
	unsigned int nPortCount = ports.GetSize();
	if( nPortSelect >= nPortCount )
	{
		MessageBox(TEXT("Select serial port failed!!!"));
		return;
	}

	unsigned int nSerialPortNum = ports.GetAt(nPortSelect);

	int nResult = ExIO_Connect(nSerialPortNum);
	if( nResult != 1 )
	{
		MessageBox(TEXT("Connect to device failed!!!"));
		//return FALSE;
	}
	else
	{
		int nMajorVersion = 0;
		int nMinorVersion = 0;
		ExIO_Get_DLL_Version(&nMajorVersion, &nMinorVersion);
		CString DLLVersion;
		DLLVersion.Format(TEXT("DLL ver : %d.%d"), nMajorVersion, nMinorVersion);

		CString strDTPVersion;
		int nDTPVersion = 0;
		nResult = ExIO_GetDTPVersion(&nDTPVersion);
		if( nResult == 1 )
		{
			strDTPVersion.Format(TEXT("MCU DTP : %d"), nDTPVersion);
		}
		else
		{
			strDTPVersion.Format(TEXT("MCU DTP : ?"));
		}

		CString strBLVersion;
		int nBLVersion = 0;
		nResult = ExIO_GetBLVersion(&nBLVersion);
		if( nResult == 1 )
		{
			strBLVersion.Format(TEXT("MCU BL : %d"), nBLVersion);
		}
		else
		{
			strBLVersion.Format(TEXT("MCU BL : ?"));
		}

		CString strDTPType;
		int nDTPType = 0;
		nResult = ExIO_GetDTPType(&nDTPType);
		if( nResult == 1 )
		{
			strDTPType.Format(TEXT("MCU DTP type : %d"), nDTPType);
		}
		else
		{
			strDTPType.Format(TEXT("MCU DTP type : ?"));
		}

		CString strOtherVersion;
		strOtherVersion = DLLVersion + TEXT(", ") + strDTPVersion + TEXT(", ") + strBLVersion + TEXT(", ") + strDTPType;
		m_CEdit_Message.SetWindowText(strOtherVersion);

		m_nStep = 0;
		SetTimer(1, 0, NULL);

		EnableButtonWhenOpen();
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton2()
{
	KillTimer(1);
	KillTimer(2);

	ExIO_Disconnect();

	DisableButtonWhenClose();
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton3()
{
	int nResult = ExIO_SetFlashUpdate();
	if( nResult == 1 )
	{
		m_CEdit_Message.SetWindowText(TEXT("Update Flash Success."));
	}
	else
	{
		m_CEdit_Message.SetWindowText(TEXT("Update Flash Failed!!!"));
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton4()
{
	int nGPI12 = m_CComboBox_GPI12Level.GetCurSel();
	int nGPI34 = m_CComboBox_GPI34Level.GetCurSel();

	int nResult = ExIO_SetExtGPILevelControl(nGPI12, nGPI34);
	if( nResult == 1 )
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPI Level Success."));

		fnGetExtGPILevel();
	}
	else
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPI Level Failed!!!"));
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton5()
{
	int nGPO12 = m_CComboBox_GPO12PullUp.GetCurSel();
	int nGPO34 = m_CComboBox_GPO34PullUp.GetCurSel();

	int nResult = ExIO_SetExtGPOPullUpControl(nGPO12, nGPO34);
	if( nResult == 1 )
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPO Pull-Up Success."));

		fnGetExtGPOPullUp();
	}
	else
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPO Pull-Up Failed!!!"));
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton6()
{
	fnGetExtGPIStatus();
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton7()
{
	int nGPO1 = m_CComboBox_GPO1.GetCurSel();
	int nGPO2 = m_CComboBox_GPO2.GetCurSel();
	int nGPO3 = m_CComboBox_GPO3.GetCurSel();
	int nGPO4 = m_CComboBox_GPO4.GetCurSel();

	int nResult = ExIO_SetExtGPOControl(nGPO1, nGPO2, nGPO3, nGPO4);
	if( nResult == 1 )
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Ext GPO Success."));

		fnGetExtGPOStatus();
	}
	else
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Ext GPO Failed!!!"));
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton8()
{
	int nRelay1 = m_CComboBox_Relay1.GetCurSel();
	int nRelay2 = m_CComboBox_Relay2.GetCurSel();
	int nRelay3 = m_CComboBox_Relay3.GetCurSel();
	int nRelay4 = m_CComboBox_Relay4.GetCurSel();

	int nResult = ExIO_SetRelayControl(nRelay1, nRelay2, nRelay3, nRelay4);
	if( nResult == 1 )
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Relay Success."));

		fnGetRelayStatus();
	}
	else
	{
		CVTK_RELAY_01_UtilityDlg* p_MainDlg = (CVTK_RELAY_01_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Relay Failed!!!"));
	}
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton9()
{
	fnGetInputCurrent();
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton10()
{
	fnGetInputVoltage();
}

void CVTK_RELAY_01_UtilityDlg::OnBnClickedButton11()
{
	fnGetInputFrequency();
}

// ================================================================================================================================================
// Enable or disable all buttons
// ================================================================================================================================================
void CVTK_RELAY_01_UtilityDlg::DisableButtonWhenClose()
{
	CWnd *pButton2 = this->GetDlgItem(IDC_BUTTON2);
	pButton2->EnableWindow(FALSE);

	CWnd *pButton3 = this->GetDlgItem(IDC_BUTTON3);
	pButton3->EnableWindow(FALSE);

	CWnd *pButton4 = this->GetDlgItem(IDC_BUTTON4);
	pButton4->EnableWindow(FALSE);

	CWnd *pButton5 = this->GetDlgItem(IDC_BUTTON5);
	pButton5->EnableWindow(FALSE);

	CWnd *pButton6 = this->GetDlgItem(IDC_BUTTON6);
	pButton6->EnableWindow(FALSE);

	CWnd *pButton7 = this->GetDlgItem(IDC_BUTTON7);
	pButton7->EnableWindow(FALSE);

	CWnd *pButton8 = this->GetDlgItem(IDC_BUTTON8);
	pButton8->EnableWindow(FALSE);

	CWnd *pButton9 = this->GetDlgItem(IDC_BUTTON9);
	pButton9->EnableWindow(FALSE);

	CWnd *pButton10 = this->GetDlgItem(IDC_BUTTON10);
	pButton10->EnableWindow(FALSE);

	CWnd *pButton11 = this->GetDlgItem(IDC_BUTTON11);
	pButton11->EnableWindow(FALSE);

	// Open Button
	CWnd *pButton1 = this->GetDlgItem(IDC_BUTTON1);
	pButton1->EnableWindow(TRUE);
}

void CVTK_RELAY_01_UtilityDlg::EnableButtonWhenOpen()
{
	CWnd *pButton2 = this->GetDlgItem(IDC_BUTTON2);
	pButton2->EnableWindow(TRUE);

	CWnd *pButton3 = this->GetDlgItem(IDC_BUTTON3);
	pButton3->EnableWindow(TRUE);

	CWnd *pButton4 = this->GetDlgItem(IDC_BUTTON4);
	pButton4->EnableWindow(TRUE);

	CWnd *pButton5 = this->GetDlgItem(IDC_BUTTON5);
	pButton5->EnableWindow(TRUE);

	CWnd *pButton6 = this->GetDlgItem(IDC_BUTTON6);
	pButton6->EnableWindow(TRUE);

	CWnd *pButton7 = this->GetDlgItem(IDC_BUTTON7);
	pButton7->EnableWindow(TRUE);

	CWnd *pButton8 = this->GetDlgItem(IDC_BUTTON8);
	pButton8->EnableWindow(TRUE);

	CWnd *pButton9 = this->GetDlgItem(IDC_BUTTON9);
	pButton9->EnableWindow(TRUE);

	CWnd *pButton10 = this->GetDlgItem(IDC_BUTTON10);
	pButton10->EnableWindow(TRUE);

	CWnd *pButton11 = this->GetDlgItem(IDC_BUTTON11);
	pButton11->EnableWindow(TRUE);

	// Open Button
	CWnd *pButton1 = this->GetDlgItem(IDC_BUTTON1);
	pButton1->EnableWindow(FALSE);
}
