﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VTC6221_Utility
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            tabControl1.TabPages[0].Text = "System 1";
            tabControl1.TabPages[1].Text = "System 2";
            tabControl1.TabPages[2].Text = "I/O";
            tabControl1.TabPages[3].Text = "Module";
            tabControl1.TabPages[4].Text = "G-Sensor";
            tabControl1.TabPages[5].Text = "Event";

            // Main Menu
            MainMenuInit();
            // Page 1 (System 1)
            Page1Init();
            // Page 2 (System 2)
            Page2Init();
            // Page 3 (I/O)
            Page3Init();
            // Page 4 (Module)
            Page4Init();
            // Page 5 (G-Sensor)
            Page5Init();
            // Page 6 (Event)
            Page6Init();

            PageSelectingInit();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            VTC6221.Disconnect();
        }

        #region Main Menu
        // ==============================================================================================================
        // Main Menu
        // ==============================================================================================================
        public void MainMenuInit()
        {
            int nMajorVersion = 0;
            int nMinorVersion = 0;
            VTC6221.Get_DLL_Version(ref nMajorVersion, ref nMinorVersion);

            string strDLLVersion;
            strDLLVersion = "DLL ver : " + nMajorVersion + "." + nMinorVersion;
            textBox_Message.Text = strDLLVersion;

            int nResult = VTC6221.Connect();
            if (nResult != 1)
            {
                MessageBox.Show("Connect to device failed!!!", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            else
            {
#if DEBUG
                string strHWVersion;
                int nHWVersion = 0;
                nResult = VTC6221.GetHWVersion(ref nHWVersion);
                if (nResult == 1)
                {
                    int nVer = 65 + nHWVersion;
                    strHWVersion = "PCB : " + Convert.ToString((char)nVer);
                }
                else
                {
                    strHWVersion = "PCB : ?";
                }

                string strDTPVersion;
                int nDTPVersion = 0;
                nResult = VTC6221.GetDTPVersion(ref nDTPVersion);
                if (nResult == 1)
                {
                    strDTPVersion = "MCU DTP : " + nDTPVersion;
                }
                else
                {
                    strDTPVersion = "MCU DTP : ?";
                }

                string strBLVersion;
                int nBLVersion = 0;
                nResult = VTC6221.GetBLVersion(ref nBLVersion);
                if (nResult == 1)
                {
                    strBLVersion = "MCU BL : " + nBLVersion;
                }
                else
                {
                    strBLVersion = "MCU BL : ?";
                }

                textBox_Message.Text = strDLLVersion + ", " + strHWVersion + ", " + strDTPVersion + ", " + strBLVersion;
#endif
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int nResult = VTC6221.SetLoadDefault();
            if (nResult == 1)
            {
                textBox_Message.Text = "Load Default Success.";
                MessageBox.Show("Loading factory default settings successfully.", this.Text);

                ReadingAfterLoadDefault();
            }
            else
            {
                textBox_Message.Text = "Load Default Failed!!!";
                MessageBox.Show("Loading factory default settings failed!!!", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
	        int nResult = VTC6221.SetFlashUpdate();
	        if( nResult == 1 )
	        {
		        textBox_Message.Text = "Update Flash Success.";

		        string strMessage;
		        strMessage = "The following settings have been saved :\n\n" +
			                 "1. Startup/Shutdown voltage\n" +
					         "2. Power On/Off Delay Timer\n" +
					         "3. WWAN\n" +
					         "4. Wake On LAN\n" +
					         "5. RTC Wake Up Timer";
                MessageBox.Show(strMessage, this.Text);
	        }
	        else
	        {
		        textBox_Message.Text = "Update Flash Failed!!!";
                MessageBox.Show("Failed to save settings!!!", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
	        }
        }
        #endregion

        #region Page 1 (System 1)
        // ==============================================================================================================
        // Page 1 (System 1)
        // ==============================================================================================================
        public void Page1Init()
        {
            comboBox_StartupShutdown.Items.Clear();
            comboBox_StartupShutdown.Items.Add("11.5V / 10.5V       23.0V / 21.0V");
            comboBox_StartupShutdown.Items.Add("12.0V / 11.0V       24.0V / 22.0V");
            comboBox_StartupShutdown.Items.Add("12.5V / 11.0V       25.0V / 22.0V");
            comboBox_StartupShutdown.Items.Add("12.5V / 11.5V       25.0V / 23.0V");
            comboBox_StartupShutdown.SelectedIndex = 0;

            // BIOS Ver
            {
                // The "Get_BIOS_Version" call "CoInitializeEx(NULL, COINIT_MULTITHREADED)" to access SMBIOS,
                // so C# must use Thread to call "Get_BIOS_Version".

                Thread_Get_BIOS_Version = new System.Threading.Thread(Thread_Get_BIOS_Version_Function);
                Thread_Get_BIOS_Version.Priority = System.Threading.ThreadPriority.Highest;
                Thread_Get_BIOS_Version.Start();
                while (!Thread_Get_BIOS_Version.IsAlive) ;
            }
        }

        private System.Threading.Thread Thread_Get_BIOS_Version = null;
        public void Thread_Get_BIOS_Version_Function()
        {
            // BIOS Ver
#if USING_WCHAR
            string strBIOS_Version = new string('\0', 32);
            bool bResult = VTC6221.Get_BIOS_Version_W(strBIOS_Version, 32);
#else
            StringBuilder strbBIOS_Version = new StringBuilder(32);
            bool bResult = VTC6221.Get_BIOS_Version(strbBIOS_Version, 32);
            string strBIOS_Version = strbBIOS_Version.ToString();
#endif
            if (bResult)
            {
                SetTextBox_BIOS_Version(strBIOS_Version);
            }
            else
            {
                SetTextBox_BIOS_Version("unknown");
            }
        }

        delegate void SetTextBox_BIOS_Version_Callback(string text);
        private void SetTextBox_BIOS_Version(string text)
        {
            if (this.textBox_BIOS_Version.InvokeRequired)
            {
                SetTextBox_BIOS_Version_Callback d = new SetTextBox_BIOS_Version_Callback(SetTextBox_BIOS_Version);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                this.textBox_BIOS_Version.Text = text;
            }
        }

        public void fnGetMCUVersion()
        {
            int nMCUVersion = 0;
            int nResult = VTC6221.GetMCUVersion(ref nMCUVersion);
            if (nResult == 1)
            {
                textBox_MCU_Version.Text = "VT640R" + nMCUVersion.ToString("D2");

            }
            else
            {
                textBox_MCU_Version.Text = "?";
            }
        }

        public void fnGetIgnitionStatus()
        {
            int nIgnitionStatus = 0;
            int nResult = VTC6221.GetIgnitionStatus(ref nIgnitionStatus);
            if (nResult == 1)
            {
                switch (nIgnitionStatus)
                {
                    case 0: textBox_Ignition.Text = "OFF"; break;
                    case 1: textBox_Ignition.Text = "ON"; break;
                    default: textBox_Ignition.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_Ignition.Text = "?";
            }
        }

        public void fnGetSupplyVoltage()
        {
            int nSupplyVoltage = 0;
            int nResult = VTC6221.GetSupplyVoltage(ref nSupplyVoltage);
            if (nResult == 1)
            {
                double fVoltage = (double)nSupplyVoltage / 1000;
                textBox_Input_Voltage.Text = fVoltage.ToString("F01") + " V";
            }
            else
            {
                textBox_Input_Voltage.Text = "?";
            }
        }

        public void fnGetPowerType()
        {
            int nPowerType = 0;
            int nResult = VTC6221.GetPowerType(ref nPowerType);
            if (nResult == 1)
            {
                switch (nPowerType)
                {
                    case 0: textBox_Power_Type.Text = "9~48V"; break;
                    case 1: textBox_Power_Type.Text = "Reserved(9~48V)"; break;
                    case 2: textBox_Power_Type.Text = "24V"; break;
                    case 3: textBox_Power_Type.Text = "12V"; break;
                    default: textBox_Power_Type.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_Power_Type.Text = "?";
            }
        }

        public void fnGetStartupShutdownOption()
        {
            int nStartupShutdownOption = 0;
            int nResult = VTC6221.GetStartupShutdownOption(ref nStartupShutdownOption);
            if (nResult == 1)
            {
                switch (nStartupShutdownOption)
                {
                    case 0: textBox_StartupShutdown.Text = "11.5V / 10.5V       23.0V / 21.0V"; break;
                    case 1: textBox_StartupShutdown.Text = "12.0V / 11.0V       24.0V / 22.0V"; break;
                    case 2: textBox_StartupShutdown.Text = "12.5V / 11.0V       25.0V / 22.0V"; break;
                    case 3: textBox_StartupShutdown.Text = "12.5V / 11.5V       25.0V / 23.0V"; break;
                    default: textBox_StartupShutdown.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_StartupShutdown.Text = "?";
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            fnGetPowerType();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            int nOption = comboBox_StartupShutdown.SelectedIndex;
            int nResult = VTC6221.SetStartupShutdownOption(nOption);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set Startup Shutdown Option Success.";

                fnGetStartupShutdownOption();
            }
            else
            {
                textBox_Message.Text = "Set Startup Shutdown Option Failed!!!";
            }
        }
        #endregion

        #region Page 2 (System 2)
        // ==============================================================================================================
        // Page 2 (System 2)
        // ==============================================================================================================
        public void Page2Init()
        {
            comboBox_PowerOffDelay.Items.Clear();
            comboBox_PowerOffDelay.Items.Add("Disable");
            comboBox_PowerOffDelay.Items.Add("Enable");
            comboBox_PowerOffDelay.SelectedIndex = 0;

            comboBox_DelayOffTime.Items.Clear();
            comboBox_DelayOffTime.Items.Add("20 Sec");
            comboBox_DelayOffTime.Items.Add("1 Min");
            comboBox_DelayOffTime.Items.Add("5 Mins");
            comboBox_DelayOffTime.Items.Add("10 Mins");
            comboBox_DelayOffTime.Items.Add("30 Mins");
            comboBox_DelayOffTime.Items.Add("1 Hour");
            comboBox_DelayOffTime.Items.Add("6 Hours");
            comboBox_DelayOffTime.Items.Add("18 Hours");
            comboBox_DelayOffTime.SelectedIndex = 0;

            comboBox_PowerOnDelay.Items.Clear();
            comboBox_PowerOnDelay.Items.Add("Disable");
            comboBox_PowerOnDelay.Items.Add("Enable");
            comboBox_PowerOnDelay.SelectedIndex = 0;

            comboBox_DelayOnTime.Items.Clear();
            comboBox_DelayOnTime.Items.Add("10 Sec");
            comboBox_DelayOnTime.Items.Add("30 Sec");
            comboBox_DelayOnTime.Items.Add("1Min");
            comboBox_DelayOnTime.Items.Add("5 Mins");
            comboBox_DelayOnTime.Items.Add("10 Mins");
            comboBox_DelayOnTime.Items.Add("15 Mins");
            comboBox_DelayOnTime.Items.Add("30 Mins");
            comboBox_DelayOnTime.Items.Add("1 Hour");
            comboBox_DelayOnTime.SelectedIndex = 0;

            comboBox_RTCWakeUp.Items.Clear();
            comboBox_RTCWakeUp.Items.Add("Disable");
            comboBox_RTCWakeUp.Items.Add("Enable");
            comboBox_RTCWakeUp.SelectedIndex = 0;

            comboBox_RTCHour.Items.Clear();
            for (int i = 0; i <= 23; i++)
            {
                comboBox_RTCHour.Items.Add(i.ToString());
            }
            comboBox_RTCHour.SelectedIndex = 0;

            comboBox_RTCMin.Items.Clear();
            for (int i = 0; i <= 59; i++)
            {
                comboBox_RTCMin.Items.Add(i.ToString());
            }
            comboBox_RTCMin.SelectedIndex = 0;

            comboBox_RTCSec.Items.Clear();
            for (int i = 0; i <= 59; i++)
            {
                comboBox_RTCSec.Items.Add(i.ToString());
            }
            comboBox_RTCSec.SelectedIndex = 0;

            comboBox_WDT.Items.Clear();
            comboBox_WDT.Items.Add("Disable");
            comboBox_WDT.Items.Add("Enable");
            comboBox_WDT.SelectedIndex = 0;

            comboBox_WDT_Interval.Items.Clear();
            for (int i = 3; i <= 255; i++)
            {
                comboBox_WDT_Interval.Items.Add(i.ToString());
            }
            comboBox_WDT_Interval.SelectedIndex = 0;
        }

        public void fnGetDelayTimeOption()
        {
            int nPowerOff = 0;
            int nPowerOn = 0;
            int nDelayOffEnable = 0;
            int nDelayOnEnable = 0;

            int nResult = VTC6221.GetDelayTimeOption(ref nPowerOff, ref nPowerOn, ref nDelayOffEnable, ref nDelayOnEnable);
            if (nResult == 1)
            {
                switch (nPowerOff)
                {
                    case 0: textBox_DelayOffTime.Text = "20 sec"; break;
                    case 1: textBox_DelayOffTime.Text = "1 Min"; break;
                    case 2: textBox_DelayOffTime.Text = "5 Mins"; break;
                    case 3: textBox_DelayOffTime.Text = "10 Mins"; break;
                    case 4: textBox_DelayOffTime.Text = "30 Mins"; break;
                    case 5: textBox_DelayOffTime.Text = "1 Hour"; break;
                    case 6: textBox_DelayOffTime.Text = "6 Hours"; break;
                    case 7: textBox_DelayOffTime.Text = "18 Hours"; break;
                    default: textBox_DelayOffTime.Text = "Undefined"; break;
                }

                switch (nPowerOn)
                {
                    case 0: textBox_DelayOnTime.Text = "10 sec"; break;
                    case 1: textBox_DelayOnTime.Text = "30 sec"; break;
                    case 2: textBox_DelayOnTime.Text = "1 Min"; break;
                    case 3: textBox_DelayOnTime.Text = "5 Mins"; break;
                    case 4: textBox_DelayOnTime.Text = "10 Mins"; break;
                    case 5: textBox_DelayOnTime.Text = "15 Mins"; break;
                    case 6: textBox_DelayOnTime.Text = "30 Mins"; break;
                    case 7: textBox_DelayOnTime.Text = "1 Hour"; break;
                    default: textBox_DelayOnTime.Text = "Undefined"; break;
                }

                switch (nDelayOffEnable)
                {
                    case 0: textBox_PowerOffDelay.Text = "Disable"; break;
                    case 1: textBox_PowerOffDelay.Text = "Enable"; break;
                    default: textBox_PowerOffDelay.Text = "Undefined"; break;
                }

                switch (nDelayOnEnable)
                {
                    case 0: textBox_PowerOnDelay.Text = "Disable"; break;
                    case 1: textBox_PowerOnDelay.Text = "Enable"; break;
                    default: textBox_PowerOnDelay.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_DelayOffTime.Text = "?";
                textBox_DelayOnTime.Text = "?";
                textBox_PowerOffDelay.Text = "?";
                textBox_PowerOnDelay.Text = "?";
            }
        }

        public void fnGetRTCStatus()
        {
            int nRTCStatus = 0;
            int nResult = VTC6221.GetRTCStatus(ref nRTCStatus);
            if (nResult == 1)
            {
                switch (nRTCStatus)
                {
                    case 0: textBox_RTCWakeUp.Text = "Disable"; break;
                    case 1: textBox_RTCWakeUp.Text = "Enable"; break;
                    default: textBox_RTCWakeUp.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_RTCWakeUp.Text = "?";
            }
        }

        public void fnGetAlarmTimer()
        {
            int nHour = 0;
            int nMin = 0;
            int nSec = 0;
            int nResult = VTC6221.GetAlarmTimer(ref nHour, ref nMin, ref nSec);
            if (nResult == 1)
            {
                textBox_RTCHour.Text = nHour.ToString();
                textBox_RTCMin.Text = nMin.ToString();
                textBox_RTCSec.Text = nSec.ToString();
            }
            else
            {
                textBox_RTCHour.Text = "?";
                textBox_RTCMin.Text = "?";
                textBox_RTCSec.Text = "?";
            }
        }

        public void fnGetWatchdogConfig()
        {
            int nWDT_Enable = 0;
            int nTimeInterval = 0;
            int nResult = VTC6221.GetWatchdogConfig(ref nWDT_Enable, ref nTimeInterval);
            if (nResult == 1)
            {
                switch (nWDT_Enable)
                {
                    case 0: textBox_WDT.Text = "Disable"; break;
                    case 1: textBox_WDT.Text = "Enable"; break;
                    default: textBox_WDT.Text = "Undefined"; break;
                }

                textBox_WDT_Interval.Text = nTimeInterval.ToString() + " Sec";
            }
            else
            {
                textBox_WDT.Text = "?";
                textBox_WDT_Interval.Text = "?";
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            int nPowerOffDelayTime = comboBox_DelayOffTime.SelectedIndex;
            int nPowerOffDelayTime_Enable = comboBox_PowerOffDelay.SelectedIndex;
            int nPowerOnDelayTime = comboBox_DelayOnTime.SelectedIndex;
            int nPowerOnDelayTime_Enable = comboBox_PowerOnDelay.SelectedIndex;
            int nResult = VTC6221.SetDelayTimeOption(nPowerOffDelayTime, nPowerOffDelayTime_Enable, nPowerOnDelayTime, nPowerOnDelayTime_Enable);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set Delay Time Option Success.";

                fnGetDelayTimeOption();
            }
            else
            {
                textBox_Message.Text = "Set Delay Time Option Failed!!!";
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            int nEnable = comboBox_RTCWakeUp.SelectedIndex;
            int nResult = VTC6221.SetRTCControl(nEnable);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set RTC Control Success.";

                fnGetRTCStatus();
            }
            else
            {
                textBox_Message.Text = "Set RTC Control Failed!!!";
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            DateTime LocalTime = DateTime.Now;
            int nResult = VTC6221.SetRTCTimer(LocalTime.Hour, LocalTime.Minute, LocalTime.Second);
            if (nResult == 1)
            {
                int nHour = comboBox_RTCHour.SelectedIndex;
                int nMin = comboBox_RTCMin.SelectedIndex;
                int nSec = comboBox_RTCSec.SelectedIndex;
                nResult = VTC6221.SetAlarmTimer(nHour, nMin, nSec);
                if (nResult == 1)
                {
                    textBox_Message.Text = "Set Alarm Timer Success.";

                    fnGetAlarmTimer();
                }
                else
                {
                    textBox_Message.Text = "Set Alarm Timer Failed!!!";
                }
            }
            else
            {
                textBox_Message.Text = "Set RTC Timer Failed!!!";
            }
        }

        private void button8_Click(object sender, EventArgs e)
        {
            int nWDT_Enable = comboBox_WDT.SelectedIndex;
            int nResult = VTC6221.SetWatchdogControl(nWDT_Enable);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set Watchdog Control success.";

                fnGetWatchdogConfig();
            }
            else
            {
                textBox_Message.Text = "Set Watchdog Control failed!!!";
            }
        }

        private void button9_Click(object sender, EventArgs e)
        {
            int nTimeInterval = comboBox_WDT_Interval.SelectedIndex + 3;
            int nResult = VTC6221.SetWatchdogTimer(nTimeInterval);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set Watchdog Timer success.";

                fnGetWatchdogConfig();
            }
            else
            {
                textBox_Message.Text = "Set Watchdog Timer failed!!!";
            }
        }
        #endregion

        #region Page 3 (I/O)
        // ==============================================================================================================
        // Page 3 (I/O)
        // ==============================================================================================================
        public void Page3Init()
        {
            comboBox_GPO1.Items.Clear();
            comboBox_GPO1.Items.Add("Low");
            comboBox_GPO1.Items.Add("High");
            comboBox_GPO1.SelectedIndex = 0;

            comboBox_GPO2.Items.Clear();
            comboBox_GPO2.Items.Add("Low");
            comboBox_GPO2.Items.Add("High");
            comboBox_GPO2.SelectedIndex = 0;

            comboBox_GPO3.Items.Clear();
            comboBox_GPO3.Items.Add("Low");
            comboBox_GPO3.Items.Add("High");
            comboBox_GPO3.SelectedIndex = 0;

            comboBox_GPO4.Items.Clear();
            comboBox_GPO4.Items.Add("Low");
            comboBox_GPO4.Items.Add("High");
            comboBox_GPO4.SelectedIndex = 0;

            comboBox_WakeOnLan.Items.Clear();
            comboBox_WakeOnLan.Items.Add("Disable");
            comboBox_WakeOnLan.Items.Add("Enable");
            comboBox_WakeOnLan.SelectedIndex = 0;

            comboBox_External12V.Items.Clear();
            comboBox_External12V.Items.Add("Disable");
            comboBox_External12V.Items.Add("Enable");
            comboBox_External12V.SelectedIndex = 0;

            comboBox_LED1.Items.Clear();
            comboBox_LED1.Items.Add("OFF");
            comboBox_LED1.Items.Add("Orange");
            comboBox_LED1.Items.Add("Green");
            comboBox_LED1.SelectedIndex = 0;

            comboBox_LED2.Items.Clear();
            comboBox_LED2.Items.Add("OFF");
            comboBox_LED2.Items.Add("Orange");
            comboBox_LED2.Items.Add("Green");
            comboBox_LED2.SelectedIndex = 0;

            comboBox_LED3.Items.Clear();
            comboBox_LED3.Items.Add("OFF");
            comboBox_LED3.Items.Add("ON");
            comboBox_LED3.SelectedIndex = 0;

            comboBox_LED4.Items.Clear();
            comboBox_LED4.Items.Add("OFF");
            comboBox_LED4.Items.Add("ON");
            comboBox_LED4.SelectedIndex = 0;
        }

        public void fnGetGPOStatus()
        {
            int nGPO1 = 0;
            int nGPO2 = 0;
            int nGPO3 = 0;
            int nGPO4 = 0;
            int nResult = VTC6221.GetGPOStatus(ref nGPO1, ref nGPO2, ref nGPO3, ref nGPO4);
            if (nResult == 1)
            {
                switch (nGPO1)
                {
                    case 0: textBox_GPO1.Text = "Low"; break;
                    case 1: textBox_GPO1.Text = "High"; break;
                    default: textBox_GPO1.Text = "Undefined"; break;
                }

                switch (nGPO2)
                {
                    case 0: textBox_GPO2.Text = "Low"; break;
                    case 1: textBox_GPO2.Text = "High"; break;
                    default: textBox_GPO2.Text = "Undefined"; break;
                }

                switch (nGPO3)
                {
                    case 0: textBox_GPO3.Text = "Low"; break;
                    case 1: textBox_GPO3.Text = "High"; break;
                    default: textBox_GPO3.Text = "Undefined"; break;
                }

                switch (nGPO4)
                {
                    case 0: textBox_GPO4.Text = "Low"; break;
                    case 1: textBox_GPO4.Text = "High"; break;
                    default: textBox_GPO4.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_GPO1.Text = "?";
                textBox_GPO2.Text = "?";
                textBox_GPO3.Text = "?";
                textBox_GPO4.Text = "?";
            }
        }

        public void fnGetGPIStatus()
        {
            int nGPI1 = 0;
            int nGPI2 = 0;
            int nGPI3 = 0;
            int nGPI4 = 0;
            int nResult = VTC6221.GetGPIStatus(ref nGPI1, ref nGPI2, ref nGPI3, ref nGPI4);
            if (nResult == 1)
            {
                switch (nGPI1)
                {
                    case 0: textBox_GPI1.Text = "Low"; break;
                    case 1: textBox_GPI1.Text = "High"; break;
                    default: textBox_GPI1.Text = "Undefined"; break;
                }

                switch (nGPI2)
                {
                    case 0: textBox_GPI2.Text = "Low"; break;
                    case 1: textBox_GPI2.Text = "High"; break;
                    default: textBox_GPI2.Text = "Undefined"; break;
                }

                switch (nGPI3)
                {
                    case 0: textBox_GPI3.Text = "Low"; break;
                    case 1: textBox_GPI3.Text = "High"; break;
                    default: textBox_GPI3.Text = "Undefined"; break;
                }

                switch (nGPI4)
                {
                    case 0: textBox_GPI4.Text = "Low"; break;
                    case 1: textBox_GPI4.Text = "High"; break;
                    default: textBox_GPI4.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_GPI1.Text = "?";
                textBox_GPI2.Text = "?";
                textBox_GPI3.Text = "?";
                textBox_GPI4.Text = "?";
            }
        }

        public void fnGetWakeOnLanStatus()
        {
            int nWakeOnLanStatus = 0;
            int nResult = VTC6221.GetWakeOnLanStatus(ref nWakeOnLanStatus);
            if (nResult == 1)
            {
                switch (nWakeOnLanStatus)
                {
                    case 0: textBox_WakeOnLan.Text = "Disable"; break;
                    case 1: textBox_WakeOnLan.Text = "Enable"; break;
                    default: textBox_WakeOnLan.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_WakeOnLan.Text = "?";
            }
        }

        public void fnGetExternal12VStatus()
        {
            int nExternal12VStatus = 0;
            int nResult = VTC6221.GetExternal12VStatus(ref nExternal12VStatus);
            if (nResult == 1)
            {
                switch (nExternal12VStatus)
                {
                    case 0: textBox_External12V.Text = "Disable"; break;
                    case 1: textBox_External12V.Text = "Enable"; break;
                    default: textBox_External12V.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_External12V.Text = "?";
            }
        }

        public void fnGetProgramLEDStatus()
        {
            int nLED_1 = 0;
            int nLED_2 = 0;
            int nLED_3 = 0;
            int nLED_Alarm = 0;

            int nResult = VTC6221.GetProgramLEDStatus(ref nLED_1, ref nLED_2, ref nLED_3, ref nLED_Alarm);
            if (nResult == 1)
            {
                switch (nLED_1)
                {
                    case 0: textBox_LED1.Text = "OFF"; break;
                    case 1: textBox_LED1.Text = "Orange"; break;
                    case 2: textBox_LED1.Text = "Green"; break;
                    default: textBox_LED1.Text = "Undefined"; break;
                }

                switch (nLED_2)
                {
                    case 0: textBox_LED2.Text = "OFF"; break;
                    case 1: textBox_LED2.Text = "Orange"; break;
                    case 2: textBox_LED2.Text = "Green"; break;
                    default: textBox_LED2.Text = "Undefined"; break;
                }

                switch (nLED_3)
                {
                    case 0: textBox_LED3.Text = "OFF"; break;
                    case 1: textBox_LED3.Text = "ON"; break;
                    default: textBox_LED3.Text = "Undefined"; break;
                }

                switch (nLED_Alarm)
                {
                    case 0: textBox_LED4.Text = "OFF"; break;
                    case 1: textBox_LED4.Text = "ON"; break;
                    default: textBox_LED4.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_LED1.Text = "?";
                textBox_LED2.Text = "?";
                textBox_LED3.Text = "?";
                textBox_LED4.Text = "?";
            }
        }

        private void button10_Click(object sender, EventArgs e)
        {
            int nGPO1 = comboBox_GPO1.SelectedIndex;
            int nGPO2 = comboBox_GPO2.SelectedIndex;
            int nGPO3 = comboBox_GPO3.SelectedIndex;
            int nGPO4 = comboBox_GPO4.SelectedIndex;
            int nResult = VTC6221.SetGPOControl(nGPO1, nGPO2, nGPO3, nGPO4);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set GPO success.";

                fnGetGPOStatus();
            }
            else
            {
                textBox_Message.Text = "Set GPO failed!!!";
            }
        }

        private void button11_Click(object sender, EventArgs e)
        {
            fnGetGPIStatus();
        }

        private void button12_Click(object sender, EventArgs e)
        {
	        int nEnable  = comboBox_WakeOnLan.SelectedIndex;
	        int nResult = VTC6221.SetWakeOnLanControl(nEnable);
	        if( nResult == 1 )
	        {
                textBox_Message.Text = "Set Wake On Lan Success.";

		        fnGetWakeOnLanStatus();
	        }
	        else
	        {
                textBox_Message.Text = "Set Wake On Lan Failed!!!";
	        }
        }

        private void button13_Click(object sender, EventArgs e)
        {
            int nEnable = comboBox_External12V.SelectedIndex;
            int nResult = VTC6221.SetExternal12VControl(nEnable);
	        if( nResult == 1 )
	        {
                textBox_Message.Text = "Set External 12V Control Success.";

		        fnGetExternal12VStatus();
	        }
	        else
	        {
                textBox_Message.Text = "Set External 12V Control Failed!!!";
	        }
        }

        private void button14_Click(object sender, EventArgs e)
        {
            int nLED1 = comboBox_LED1.SelectedIndex;
            int nLED2 = comboBox_LED2.SelectedIndex;
            int nLED3 = comboBox_LED3.SelectedIndex;
            int nLED_Alarm = comboBox_LED4.SelectedIndex;

            int nResult = VTC6221.SetProgramLEDControl(nLED1, nLED2, nLED3, nLED_Alarm);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set Program LED Control Success.";

                fnGetProgramLEDStatus();
            }
            else
            {
                textBox_Message.Text = "Set Program LED Control Failed!!!";
            }
        }
        #endregion

        #region Page 4 (Module)
        // ==============================================================================================================
        // Page 4 (Module)
        // ==============================================================================================================
        public void Page4Init()
        {
            comboBox_WWAN1.Items.Clear();
            comboBox_WWAN1.Items.Add("Disable");
            comboBox_WWAN1.Items.Add("Enable");
            comboBox_WWAN1.SelectedIndex = 1;

            comboBox_WWAN2.Items.Clear();
            comboBox_WWAN2.Items.Add("Disable");
            comboBox_WWAN2.Items.Add("Enable");
            comboBox_WWAN2.SelectedIndex = 1;

            comboBox_WWAN3.Items.Clear();
            comboBox_WWAN3.Items.Add("Disable");
            comboBox_WWAN3.Items.Add("Enable");
            comboBox_WWAN3.SelectedIndex = 1;

            comboBox_WWAN3_Wakeup.Items.Clear();
            comboBox_WWAN3_Wakeup.Items.Add("Disable");
            comboBox_WWAN3_Wakeup.Items.Add("Enable");
            comboBox_WWAN3_Wakeup.SelectedIndex = 0;

            comboBox_WWAN4.Items.Clear();
            comboBox_WWAN4.Items.Add("Disable");
            comboBox_WWAN4.Items.Add("Enable");
            comboBox_WWAN4.SelectedIndex = 1;

            comboBox_WiFi1.Items.Clear();
            comboBox_WiFi1.Items.Add("Disable");
            comboBox_WiFi1.Items.Add("Enable");
            comboBox_WiFi1.SelectedIndex = 1;

            comboBox_WiFi2.Items.Clear();
            comboBox_WiFi2.Items.Add("Disable");
            comboBox_WiFi2.Items.Add("Enable");
            comboBox_WiFi2.SelectedIndex = 1;

            comboBox_WiFi3.Items.Clear();
            comboBox_WiFi3.Items.Add("Disable");
            comboBox_WiFi3.Items.Add("Enable");
            comboBox_WiFi3.SelectedIndex = 1;

            comboBox_BT1.Items.Clear();
            comboBox_BT1.Items.Add("Disable");
            comboBox_BT1.Items.Add("Enable");
            comboBox_BT1.SelectedIndex = 1;

            comboBox_BT2.Items.Clear();
            comboBox_BT2.Items.Add("Disable");
            comboBox_BT2.Items.Add("Enable");
            comboBox_BT2.SelectedIndex = 1;

            comboBox_BT3.Items.Clear();
            comboBox_BT3.Items.Add("Disable");
            comboBox_BT3.Items.Add("Enable");
            comboBox_BT3.SelectedIndex = 1;

            comboBox_GPS.Items.Clear();
            comboBox_GPS.Items.Add("Disable");
            comboBox_GPS.Items.Add("Enable");
            comboBox_GPS.SelectedIndex = 1;

            comboBox_SIM1.Items.Clear();
            comboBox_SIM1.Items.Add("SIM Card 1");
            comboBox_SIM1.Items.Add("SIM Card 2");
            comboBox_SIM1.SelectedIndex = 0;

            comboBox_SIM2.Items.Clear();
            comboBox_SIM2.Items.Add("SIM Card 1");
            comboBox_SIM2.Items.Add("SIM Card 2");
            comboBox_SIM2.SelectedIndex = 0;

            comboBox_SIM3.Items.Clear();
            comboBox_SIM3.Items.Add("SIM Card 1");
            comboBox_SIM3.Items.Add("SIM Card 2");
            comboBox_SIM3.SelectedIndex = 0;

            comboBox_SIM4.Items.Clear();
            comboBox_SIM4.Items.Add("SIM Card 1");
            comboBox_SIM4.Items.Add("SIM Card 2");
            comboBox_SIM4.SelectedIndex = 0;
        }

        public void fnGetWWANStatus()
        {
            int nWWAN_Enable = 0;
            int nWWAN_Enable2 = 0;
            int nWWAN_Enable3 = 0;
            int nWWAN_Wakeup_Enable3 = 0;
            int nWWAN_Enable4 = 0;

            int nResult = VTC6221.GetWWANStatus(ref nWWAN_Enable, ref nWWAN_Enable2, ref nWWAN_Enable3, ref nWWAN_Wakeup_Enable3, ref nWWAN_Enable4);
            if (nResult == 1)
            {
                switch (nWWAN_Enable)
                {
                    case 0: textBox_WWAN1.Text = "Disable"; break;
                    case 1: textBox_WWAN1.Text = "Enable"; break;
                    default: textBox_WWAN1.Text = "Undefined"; break;
                }

                switch (nWWAN_Enable2)
                {
                    case 0: textBox_WWAN2.Text = "Disable"; break;
                    case 1: textBox_WWAN2.Text = "Enable"; break;
                    default: textBox_WWAN2.Text = "Undefined"; break;
                }

                switch (nWWAN_Enable3)
                {
                    case 0: textBox_WWAN3.Text = "Disable"; break;
                    case 1: textBox_WWAN3.Text = "Enable"; break;
                    default: textBox_WWAN3.Text = "Undefined"; break;
                }

                switch (nWWAN_Wakeup_Enable3)
                {
                    case 0: textBox_WWAN3_Wakeup.Text = "Disable"; break;
                    case 1: textBox_WWAN3_Wakeup.Text = "Enable"; break;
                    default: textBox_WWAN3_Wakeup.Text = "Undefined"; break;
                }

                switch (nWWAN_Enable4)
                {
                    case 0: textBox_WWAN4.Text = "Disable"; break;
                    case 1: textBox_WWAN4.Text = "Enable"; break;
                    default: textBox_WWAN4.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_WWAN1.Text = "?";
                textBox_WWAN2.Text = "?";
                textBox_WWAN3.Text = "?";
                textBox_WWAN3_Wakeup.Text = "?";
                textBox_WWAN4.Text = "?";
            }
        }

        public void fnGetWiFiStatus()
        {
            int nWiFi_En1 = 0;
            int nWiFi_En2 = 0;
            int nWiFi_En3 = 0;
            int nWiFi_Pw1 = 1; // Power on/off is used for USB module only.
            int nWiFi_Pw2 = 1; // Power on/off is used for USB module only.
            int nWiFi_Pw3 = 1; // Power on/off is used for USB module only.

            int nResult = VTC6221.GetWiFiStatus(ref nWiFi_En1, ref nWiFi_En2, ref nWiFi_En3, ref nWiFi_Pw1, ref nWiFi_Pw2, ref nWiFi_Pw3);
            if (nResult == 1)
            {
                switch (nWiFi_En1)
                {
                    case 0: textBox_WiFi1.Text = "Disable"; break;
                    case 1: textBox_WiFi1.Text = "Enable"; break;
                    default: textBox_WiFi1.Text = "Undefined"; break;
                }

                switch (nWiFi_En2)
                {
                    case 0: textBox_WiFi2.Text = "Disable"; break;
                    case 1: textBox_WiFi2.Text = "Enable"; break;
                    default: textBox_WiFi2.Text = "Undefined"; break;
                }

                switch (nWiFi_En3)
                {
                    case 0: textBox_WiFi3.Text = "Disable"; break;
                    case 1: textBox_WiFi3.Text = "Enable"; break;
                    default: textBox_WiFi3.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_WiFi1.Text = "?";
                textBox_WiFi2.Text = "?";
                textBox_WiFi3.Text = "?";
            }
        }

        public void fnGetBTStatus()
        {
            int nBTStatus1 = 0;
            int nBTStatus2 = 0;
            int nBTStatus3 = 0;

            int nResult = VTC6221.GetBTStatus(ref nBTStatus1, ref nBTStatus2, ref nBTStatus3);
            if (nResult == 1)
            {
                switch (nBTStatus1)
                {
                    case 0: textBox_BT1.Text = "Disable"; break;
                    case 1: textBox_BT1.Text = "Enable"; break;
                    default: textBox_BT1.Text = "Undefined"; break;
                }

                switch (nBTStatus2)
                {
                    case 0: textBox_BT2.Text = "Disable"; break;
                    case 1: textBox_BT2.Text = "Enable"; break;
                    default: textBox_BT2.Text = "Undefined"; break;
                }

                switch (nBTStatus3)
                {
                    case 0: textBox_BT3.Text = "Disable"; break;
                    case 1: textBox_BT3.Text = "Enable"; break;
                    default: textBox_BT3.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_BT1.Text = "?";
                textBox_BT2.Text = "?";
                textBox_BT3.Text = "?";
            }
        }

        public void fnGetGPSStatus()
        {
            int nGPSStatus = 0;
            int nResult = VTC6221.GetGPSStatus(ref nGPSStatus);
            if (nResult == 1)
            {
                switch (nGPSStatus)
                {
                    case 0: textBox_GPS.Text = "Disable"; break;
                    case 1: textBox_GPS.Text = "Enable"; break;
                    default: textBox_GPS.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_GPS.Text = "?";
            }
        }

        public void fnGetSIMCardStatus()
        {
            int nSIMCard1 = 0;
            int nSIMCard2 = 0;
            int nSIMCard3 = 0;
            int nSIMCard4 = 0;

            int nResult = VTC6221.GetSIMCardStatus(ref nSIMCard1, ref nSIMCard2, ref nSIMCard3, ref nSIMCard4);
            if (nResult == 1)
            {
                switch (nSIMCard1)
                {
                    case 0: textBox_SIM1.Text = "SIM Card 1"; break;
                    case 1: textBox_SIM1.Text = "SIM Card 2"; break;
                    default: textBox_SIM1.Text = "Undefined"; break;
                }

                switch (nSIMCard2)
                {
                    case 0: textBox_SIM2.Text = "SIM Card 1"; break;
                    case 1: textBox_SIM2.Text = "SIM Card 2"; break;
                    default: textBox_SIM2.Text = "Undefined"; break;
                }

                switch (nSIMCard3)
                {
                    case 0: textBox_SIM3.Text = "SIM Card 1"; break;
                    case 1: textBox_SIM3.Text = "SIM Card 2"; break;
                    default: textBox_SIM3.Text = "Undefined"; break;
                }

                switch (nSIMCard4)
                {
                    case 0: textBox_SIM4.Text = "SIM Card 1"; break;
                    case 1: textBox_SIM4.Text = "SIM Card 2"; break;
                    default: textBox_SIM4.Text = "Undefined"; break;
                }
            }
            else
            {
                textBox_SIM1.Text = "?";
                textBox_SIM2.Text = "?";
                textBox_SIM3.Text = "?";
                textBox_SIM4.Text = "?";
            }
        }

        public void fnGetPCIESlotMode()
        {
            int nCN5 = 0;
            int nCN23 = 1;

            if (VTC6221.GetPCIESlotMode(ref nCN5, ref nCN23) == 1)
            {
                if (nCN5 == 1)
                { // 1: WIFI#3
                    label_WWAN1.Hide();
                    textBox_WWAN1.Hide();
                    comboBox_WWAN1.Hide();

                    label_SIM1.Hide();
                    textBox_SIM1.Hide();
                    comboBox_SIM1.Hide();

                    label_WiFi3.Show();
                    textBox_WiFi3.Show();
                    comboBox_WiFi3.Show();

                    label_BT3.Show();
                    textBox_BT3.Show();
                    comboBox_BT3.Show();
                }
                else
                { // 0: WWAN#1(default)
                    label_WWAN1.Show();
                    textBox_WWAN1.Show();
                    comboBox_WWAN1.Show();

                    label_SIM1.Show();
                    textBox_SIM1.Show();
                    comboBox_SIM1.Show();

                    label_WiFi3.Hide();
                    textBox_WiFi3.Hide();
                    comboBox_WiFi3.Hide();

                    label_BT3.Hide();
                    textBox_BT3.Hide();
                    comboBox_BT3.Hide();
                }

                if (nCN23 == 1)
                { // 1: WIFI#2 (default)
                    label_WWAN4.Hide();
                    textBox_WWAN4.Hide();
                    comboBox_WWAN4.Hide();

                    label_SIM4.Hide();
                    textBox_SIM4.Hide();
                    comboBox_SIM4.Hide();

                    label_WiFi2.Show();
                    textBox_WiFi2.Show();
                    comboBox_WiFi2.Show();

                    label_BT2.Show();
                    textBox_BT2.Show();
                    comboBox_BT2.Show();
                }
                else
                { // 0: WWAN#4
                    label_WWAN4.Show();
                    textBox_WWAN4.Show();
                    comboBox_WWAN4.Show();

                    label_SIM4.Show();
                    textBox_SIM4.Show();
                    comboBox_SIM4.Show();

                    label_WiFi2.Hide();
                    textBox_WiFi2.Hide();
                    comboBox_WiFi2.Hide();

                    label_BT2.Hide();
                    textBox_BT2.Hide();
                    comboBox_BT2.Hide();
                }
            }
        }

        private void button15_Click(object sender, EventArgs e)
        {
            int nWWAN_Enable = comboBox_WWAN1.SelectedIndex;
            int nWWAN_Enable2 = comboBox_WWAN2.SelectedIndex;
            int nWWAN_Enable3 = comboBox_WWAN3.SelectedIndex;
            int nWWAN_Wakeup_Enable3 = comboBox_WWAN3_Wakeup.SelectedIndex;
            int nWWAN_Enable4 = comboBox_WWAN4.SelectedIndex;

            int nResult = VTC6221.SetWWANControl(nWWAN_Enable, nWWAN_Enable2, nWWAN_Enable3, nWWAN_Wakeup_Enable3, nWWAN_Enable4);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set WWAN Control success.";

                fnGetWWANStatus();
            }
            else
            {
                textBox_Message.Text = "Set WWAN Control failed!!!";
            }
        }

        private void button16_Click(object sender, EventArgs e)
        {
            int nWiFi_En1 = comboBox_WiFi1.SelectedIndex;
            int nWiFi_En2 = comboBox_WiFi2.SelectedIndex;
            int nWiFi_En3 = comboBox_WiFi3.SelectedIndex;
            int nWiFi_Pw1 = 1; // Power on/off is used for USB module only.
            int nWiFi_Pw2 = 1; // Power on/off is used for USB module only.
            int nWiFi_Pw3 = 1; // Power on/off is used for USB module only.

            int nResult = VTC6221.SetWiFiControl(nWiFi_En1, nWiFi_En2, nWiFi_En3, nWiFi_Pw1, nWiFi_Pw2, nWiFi_Pw3);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set WiFi Control success.";

                fnGetWiFiStatus();
            }
            else
            {
                textBox_Message.Text = "Set WiFi Control failed!!!";
            }
        }

        private void button17_Click(object sender, EventArgs e)
        {
            int nBT1 = comboBox_BT1.SelectedIndex;
            int nBT2 = comboBox_BT2.SelectedIndex;
            int nBT3 = comboBox_BT3.SelectedIndex;

            int nResult = VTC6221.SetBTControl(nBT1, nBT2, nBT3);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set BT Control success.";

                fnGetBTStatus();
            }
            else
            {
                textBox_Message.Text = "Set BT Control failed!!!";
            }
        }

        private void button18_Click(object sender, EventArgs e)
        {
            int nGPS_Enable = comboBox_GPS.SelectedIndex;
            int nResult = VTC6221.SetGPSControl(nGPS_Enable);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set GPS Control success.";

                fnGetGPSStatus();
            }
            else
            {
                textBox_Message.Text = "Set GPS Control failed!!!";
            }
        }

        private void button19_Click(object sender, EventArgs e)
        {
            int nSIMCardSelect1 = comboBox_SIM1.SelectedIndex;
            int nSIMCardSelect2 = comboBox_SIM2.SelectedIndex;
            int nSIMCardSelect3 = comboBox_SIM3.SelectedIndex;
            int nSIMCardSelect4 = comboBox_SIM4.SelectedIndex;

            int nResult = VTC6221.SetSIMCardSelect(nSIMCardSelect1, nSIMCardSelect2, nSIMCardSelect3, nSIMCardSelect4);
            if (nResult == 1)
            {
                textBox_Message.Text = "Set SIM Card Select Success.";

                fnGetSIMCardStatus();
            }
            else
            {
                textBox_Message.Text = "Set SIM Card Select Failed!!!";
            }
        }
        #endregion

        #region Page 5 (G-Sensor)
        // ==============================================================================================================
        // Page 5 (G-Sensor)
        // ==============================================================================================================
        public void Page5Init()
        {
            comboBox_GSensorRegIndex.Items.Clear();
            comboBox_GSensorRegIndex.Items.Add("00 : DEVID");
            comboBox_GSensorRegIndex.Items.Add("29 : THRESH_TAP");
            comboBox_GSensorRegIndex.Items.Add("30 : OFSX");
            comboBox_GSensorRegIndex.Items.Add("31 : OFSY");
            comboBox_GSensorRegIndex.Items.Add("32 : OFSZ");
            comboBox_GSensorRegIndex.Items.Add("33 : DUR");
            comboBox_GSensorRegIndex.Items.Add("34 : Latent");
            comboBox_GSensorRegIndex.Items.Add("35 : Window");
            comboBox_GSensorRegIndex.Items.Add("36 : THRESH_ACT");
            comboBox_GSensorRegIndex.Items.Add("37 : THRESH_INACT");
            comboBox_GSensorRegIndex.Items.Add("38 : TIME_INACT");
            comboBox_GSensorRegIndex.Items.Add("39 : ACT_INACT_CTL");
            comboBox_GSensorRegIndex.Items.Add("40 : THRESH_FF");
            comboBox_GSensorRegIndex.Items.Add("41 : TIME_FF");
            comboBox_GSensorRegIndex.Items.Add("42 : TAP_AXES");
            comboBox_GSensorRegIndex.Items.Add("43 : ACT_TAP_STATUS");
            comboBox_GSensorRegIndex.Items.Add("44 : BW_RATE");
            comboBox_GSensorRegIndex.Items.Add("45 : POWER_CTL");
            comboBox_GSensorRegIndex.Items.Add("46 : INT_ENABLE");
            comboBox_GSensorRegIndex.Items.Add("47 : INT_MAP");
            comboBox_GSensorRegIndex.Items.Add("48 : INT_SOURCE");
            comboBox_GSensorRegIndex.Items.Add("49 : DATA_FORMAT");
            comboBox_GSensorRegIndex.Items.Add("50 : DATA_X0");
            comboBox_GSensorRegIndex.Items.Add("51 : DATA_X1");
            comboBox_GSensorRegIndex.Items.Add("52 : DATA_Y0");
            comboBox_GSensorRegIndex.Items.Add("53 : DATA_Y1");
            comboBox_GSensorRegIndex.Items.Add("54 : DATA_Z0");
            comboBox_GSensorRegIndex.Items.Add("55 : DATA_Z1");
            comboBox_GSensorRegIndex.Items.Add("56 : FIFO_CTL");
            comboBox_GSensorRegIndex.Items.Add("57 : FIFO_STATUS");
            comboBox_GSensorRegIndex.SelectedIndex = 17;

            textBox_WriteGSensor.Text = "0A";

            listView_GSensor.Clear();
            listView_GSensor.View = View.Details;
            listView_GSensor.LabelEdit = false;
            listView_GSensor.AllowColumnReorder = false;
            listView_GSensor.CheckBoxes = false;
            listView_GSensor.FullRowSelect = false;
            listView_GSensor.GridLines = true;
            listView_GSensor.Sorting = SortOrder.None;

            listView_GSensor.Columns.Clear();
            listView_GSensor.Columns.Add("Num", 40);
            listView_GSensor.Columns.Add("Name", 110);
            listView_GSensor.Columns.Add("Type", 40);
            listView_GSensor.Columns.Add("Value", 46);
            listView_GSensor.Columns.Add("Description", 300);
        }

        public byte GetAddress(int nIndex)
        {
            byte byAddress = 0;
            if (nIndex == 0)
                byAddress = 0;
            else
                byAddress = (byte)(nIndex + 0x1C);

            if (byAddress < 0 && byAddress > 0x39)
                byAddress = 0;

            return byAddress;
        }

        public string[] m_strName = new string[]{
						"DEVID",
						"Reserved",
						"THRESH_TAP",
						"OFSX",
						"OFSY",
						"OFSZ",
						"DUR",
						"Latent",
						"Window",
						"THRESH_ACT",
						"THRESH_INACT",
						"TIME_INACT",
						"ACT_INACT_CTL",
						"THRESH_FF",
						"TIME_FF",
						"TAP_AXES",
						"ACT_TAP_STATUS",
						"BW_RATE",
						"POWER_CTL",
						"INT_ENABLE",
						"INT_MAP",
						"INT_SOURCE",
						"DATA_FORMAT",
						"DATAX0",
						"DATAX1",
						"DATAY0",
						"DATAY1",
						"DATAZ0",
						"DATAZ1",
						"FIFO_CTL",
						"FIFO_STATUS"};

        public string[] m_strType = new string[]{
						"R",
						"",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R",
						"R/W",
						"R/W",
						"R/W",
						"R/W",
						"R",
						"R/W",
						"R",
						"R",
						"R",
						"R",
						"R",
						"R",
						"R/W",
						"R"};

        public string[] m_strDescription = new string[] {
						"Device ID",
						"Reserved; do not access",
						"Tap threshold",
						"X-axis offset",
						"Y-axis offset",
						"Z-axis offset",
						"Tap duration",
						"Tap latency",
						"Tap window",
						"Activity threshold",
						"Inactivity threshold",
						"Inactivity time",
						"Axis enable control for activity and inactivity detection",
						"Free-fall threshold",
						"Free-fall time",
						"Axis control for single tap/double tap",
						"Source of single tap/double tap",
						"Data rate and power mode control",
						"Power-saving features control",
						"Interrupt enable control",
						"Interrupt mapping control",
						"Source of interrupts",
						"Data format control",
						"X-Axis Data 0",
						"X-Axis Data 1",
						"Y-Axis Data 0",
						"Y-Axis Data 1",
						"Z-Axis Data 0",
						"Z-Axis Data 1",
						"FIFO control",
						"FIFO status"};

        public void fnSetGsensorData()
        {
            string strData = textBox_WriteGSensor.Text;
            if (textBox_WriteGSensor.Text.Length > 2)
            {
                strData = textBox_WriteGSensor.Text.Substring(textBox_WriteGSensor.Text.Length - 2, 2);
            }

            byte[] byDataArray = new byte[] { byte.Parse(strData, System.Globalization.NumberStyles.HexNumber) };
            byte byRegIdx = GetAddress( comboBox_GSensorRegIndex.SelectedIndex );

            int nResult = VTC6221.SetGsensorData(byRegIdx, byDataArray, 1);
	        if( nResult == 1 )
	        {
                textBox_Message.Text = "Set Gsensor Data Success.";
	        }
	        else
	        {
                textBox_Message.Text = "Set Gsensor Data Failed!!!";
	        }
        }

        public void fnGetGsensorData()
        {
            int nRegIdx = (int)GetAddress( comboBox_GSensorRegIndex.SelectedIndex );
            byte[] byDataArray = new byte[] {0};

	        int nResult = VTC6221.GetGsensorData(nRegIdx, byDataArray, 1);
	        if( nResult == 1 )
	        {
                textBox_ReadGSensor.Text = byDataArray[0].ToString("X2");
	        }
	        else
	        {
		        textBox_ReadGSensor.Text = "?";
	        }
        }

        public void fnGetAllGsensorData()
        {
            listView_GSensor.Items.Clear();

            byte[] byDataArray = new byte[128];
            for(int i=0;i<128;i++)
            {
                byDataArray[i] = 0;
            }

            int nResult = VTC6221.GetGsensorData(0, byDataArray, 1);
	        if( nResult == 1 )
	        {
                string strGsensorData;
                strGsensorData = byDataArray[0].ToString("X2");

                ListViewItem item1 = new ListViewItem("0");
                item1.SubItems.Add(m_strName[0]);
                item1.SubItems.Add(m_strType[0]);
                item1.SubItems.Add(strGsensorData);
                item1.SubItems.Add(m_strDescription[0]);

                ListViewItem item2 = new ListViewItem("1~28");
                item2.SubItems.Add(m_strName[1]);
                item2.SubItems.Add(m_strType[1]);
                item2.SubItems.Add("");
                item2.SubItems.Add(m_strDescription[1]);

                listView_GSensor.Items.Add(item1);
                listView_GSensor.Items.Add(item2);

                for (int i = 0; i < 128; i++)
                {
                    byDataArray[i] = 0;
                }

                nResult = VTC6221.GetGsensorData(29, byDataArray, 29);
		        if( nResult == 1 )
		        {
			        for ( int i=0 ; i<29 ; i++ )
			        {
                        string strData;
                        strData = byDataArray[i].ToString("X2");

                        ListViewItem item = new ListViewItem((i+29).ToString());
                        item.SubItems.Add(m_strName[i+2]);
                        item.SubItems.Add(m_strType[i+2]);
                        item.SubItems.Add(strData);
                        item.SubItems.Add(m_strDescription[i+2]);

                        listView_GSensor.Items.Add(item);
			        }

                    textBox_Message.Text = "Get all Gsensor Data Success.";

			        return;
		        }
	        }

            textBox_Message.Text = "Get all Gsensor Data Failed!!!";
        }

        public void fnGetGsensorDataXYZ()
        {
            byte[] byDataArray = new byte[7];
            for(int i=0;i<7;i++)
            {
                byDataArray[i] = 0;
            }

            int nResult = VTC6221.GetGsensorData(50, byDataArray, 6);
	        if( nResult == 1 )
	        {
                textBox_GSensorX.Text = ((short)(byDataArray[0] | (byDataArray[1] << 8))).ToString();
                textBox_GSensorY.Text = ((short)(byDataArray[2] | (byDataArray[3] << 8))).ToString();
                textBox_GSensorZ.Text = ((short)(byDataArray[4] | (byDataArray[5] << 8))).ToString();
	        }
        }

        private void button20_Click(object sender, EventArgs e)
        {
            fnGetGsensorData();
        }

        private void button21_Click(object sender, EventArgs e)
        {
            fnSetGsensorData();
        }

        private void button22_Click(object sender, EventArgs e)
        {
            fnGetAllGsensorData();
        }
        #endregion

        #region Page 6 (Event)
        // ==============================================================================================================
        // Page 6 (Event)
        // ==============================================================================================================
        public void Page6Init()
        {
            fnCallBackFun = new VTC6221.EventSystemAlarm_CallBack(EventSystemAlarm);
            VTC6221.RegisterSystemAlarmCallBackFunction(fnCallBackFun);

            listBox_Event.Sorted = false;

            label_Event.Text = "System event type : \r1. Over voltage\r2. Lower voltage\r3. Over temperature\r4. Lower temperature";
        }

        VTC6221.EventSystemAlarm_CallBack fnCallBackFun = null;

        public void EventSystemAlarm(byte byAlarm)
        {
            DateTime dtTime = DateTime.Now;

            string strTime;
            strTime = dtTime.Year.ToString("D4") + "/" + dtTime.Month.ToString("D2") + "/" + dtTime.Day.ToString("D2") + " " + dtTime.Hour.ToString("D2") + ":" + dtTime.Minute.ToString("D2") + ":" + dtTime.Second.ToString("D2") + ":" + dtTime.Millisecond.ToString("D3") + " ==> ";

            if ((byAlarm & 0x01) == 0x01)
            {
                Add_Message(strTime + "Over voltage");
            }

            if ((byAlarm & 0x02) == 0x02)
            {
                Add_Message(strTime + "Lower voltage");
            }

            if ((byAlarm & 0x04) == 0x04)
            {
                Add_Message(strTime + "Over temperature");
            }

            if ((byAlarm & 0x08) == 0x08)
            {
                Add_Message(strTime + "Lower temperature");
            }
        }


        delegate void Add_Message_Callback(string msg);
        private void Add_Message(string msg)
        {
            if (this.listBox_Event.InvokeRequired)
            {
                Add_Message_Callback d = new Add_Message_Callback(Add_Message);
                this.Invoke(d, new object[] { msg });
            }
            else
            {
                while (listBox_Event.Items.Count >= 200)
                {
                    listBox_Event.Items.RemoveAt(0);
                }

                listBox_Event.Items.Add(msg);

                listBox_Event.SelectedIndex = listBox_Event.Items.Count - 1;
            }
        }
        #endregion

        #region Page Selecting
        // ==============================================================================================================
        // Page Selecting
        // ==============================================================================================================
        public void PageSelectingInit()
        {
            timer_Page1.Interval = 100;
            timer_Page1.Start();
        }

        public void ReadingAfterLoadDefault()
        {
            m_nPage1_Step = 0;
            m_nPage2_Step = 0;
            m_nPage3_Step = 0;
            m_nPage4_Step = 0;

            tabControl1_Selecting(this, null);
        }

        private void tabControl1_Selecting(object sender, TabControlCancelEventArgs e)
        {
            textBox_Message.Text = "";

            switch (tabControl1.SelectedIndex)
            {
                case 0:
                    {
                        timer_Page1.Interval = 10;
                        timer_Page1.Start();
                    }
                    break;
                case 1:
                    {
                        timer_Page2.Interval = 10;
                        timer_Page2.Start();
                    }
                    break;
                case 2:
                    {
                        timer_Page3.Interval = 10;
                        timer_Page3.Start();
                    }
                    break;
                case 3:
                    {
                        timer_Page4.Interval = 10;
                        timer_Page4.Start();
                    }
                    break;
                case 4:
                    {
                        timer_Page5.Interval = 10;
                        timer_Page5.Start();
                    }
                    break;
            }
        }

        private uint m_nPage1_Step = 0;
        private void timer_Page1_Tick(object sender, EventArgs e)
        {
            timer_Page1.Stop();

            switch (m_nPage1_Step)
            {
                case 0: fnGetMCUVersion();              m_nPage1_Step++; break;
                case 1: fnGetIgnitionStatus();          m_nPage1_Step++; break;
                case 2: fnGetSupplyVoltage();           m_nPage1_Step++; break;
                case 3: fnGetPowerType();               m_nPage1_Step++; break;
                case 4: fnGetStartupShutdownOption();   m_nPage1_Step++; break;
                default: break;
            }

            if (m_nPage1_Step < 5)
            {
                timer_Page1.Interval = 100;
                timer_Page1.Start();
            }
            else
            {
                timer_Page1_AutoRead.Interval = 100;
                timer_Page1_AutoRead.Start();
            }
        }

        private uint m_nPage1_ReadCount = 0;
        private void timer_Page1_AutoRead_Tick(object sender, EventArgs e)
        {
            timer_Page1_AutoRead.Stop();

            if (tabControl1.SelectedIndex == 0)
            {
                switch (m_nPage1_ReadCount % 2)
                {
                    case 0: fnGetIgnitionStatus();  break;
                    case 1: fnGetSupplyVoltage();   break;
                }

                m_nPage1_ReadCount++;
            }

            timer_Page1_AutoRead.Interval = 200;
            timer_Page1_AutoRead.Start();
        }

        private uint m_nPage2_Step = 0;
        private void timer_Page2_Tick(object sender, EventArgs e)
        {
            timer_Page2.Stop();

            switch (m_nPage2_Step)
            {
                case 0: fnGetDelayTimeOption(); m_nPage2_Step++; break;
                case 1: fnGetRTCStatus();       m_nPage2_Step++; break;
                case 2: fnGetAlarmTimer();      m_nPage2_Step++; break;
                case 3: fnGetWatchdogConfig();  m_nPage2_Step++; break;
                default: break;
            }

            if (m_nPage2_Step < 4)
            {
                timer_Page2.Interval = 50;
                timer_Page2.Start();
            }
        }

        private uint m_nPage3_Step = 0;
        private void timer_Page3_Tick(object sender, EventArgs e)
        {
            timer_Page3.Stop();

            switch (m_nPage3_Step)
            {
                case 0: fnGetGPOStatus();           m_nPage3_Step++; break;
                case 1: fnGetGPIStatus();           m_nPage3_Step++; break;
                case 2: fnGetWakeOnLanStatus();     m_nPage3_Step++; break;
                case 3: fnGetExternal12VStatus();   m_nPage3_Step++; break;
                case 4: fnGetProgramLEDStatus();    m_nPage3_Step++; break;
                default: break;
            }

            if (m_nPage3_Step < 5)
            {
                timer_Page3.Interval = 100;
                timer_Page3.Start();
            }
            else
            {
                timer_Page3_AutoRead.Interval = 100;
                timer_Page3_AutoRead.Start();
            }
        }

        private void timer_Page3_AutoRead_Tick(object sender, EventArgs e)
        {
            timer_Page3_AutoRead.Stop();

            if (tabControl1.SelectedIndex == 2)
            {
                fnGetGPIStatus();
            }

            timer_Page3_AutoRead.Interval = 500;
            timer_Page3_AutoRead.Start();
        }

        private uint m_nPage4_Step = 0;
        private void timer_Page4_Tick(object sender, EventArgs e)
        {
            timer_Page4.Stop();

            switch (m_nPage4_Step)
            {
                case 0: fnGetWWANStatus();      m_nPage4_Step++; break;
                case 1: fnGetWiFiStatus();      m_nPage4_Step++; break;
                case 2: fnGetBTStatus();        m_nPage4_Step++; break;
                case 3: fnGetGPSStatus();       m_nPage4_Step++; break;
                case 4: fnGetSIMCardStatus();   m_nPage4_Step++; break;
                case 5: fnGetPCIESlotMode();    m_nPage4_Step++; break;
                default: break;
            }

            if (m_nPage4_Step < 6)
            {
                timer_Page4.Interval = 100;
                timer_Page4.Start();
            }
        }

        private uint m_nPage5_Step = 0;
        private void timer_Page5_Tick(object sender, EventArgs e)
        {
            timer_Page5.Stop();

            switch (m_nPage5_Step)
            {
                case 0: fnSetGsensorData();     m_nPage5_Step++; break;
                case 1: fnGetGsensorData();     m_nPage5_Step++; break;
                case 2: fnGetAllGsensorData();  m_nPage5_Step++; break;
                default: break;
            }

            if (m_nPage5_Step < 3)
            {
                timer_Page5.Interval = 100;
                timer_Page5.Start();
            }
            else
            {
                timer_Page5_AutoRead.Interval = 200;
                timer_Page5_AutoRead.Start();
            }
        }

        private void timer_Page5_AutoRead_Tick(object sender, EventArgs e)
        {
            timer_Page5_AutoRead.Stop();

            if (tabControl1.SelectedIndex == 4)
            {
                fnGetGsensorDataXYZ();
            }

            timer_Page5_AutoRead.Interval = 200;
            timer_Page5_AutoRead.Start();
        }
        #endregion
    }
}
