// DialogConfigTab5.cpp : @
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "DialogConfigTab5.h"
#include "VTC6221.h"
#include "VTC6221_UtilityDlg.h"
#include "Useful_Function.h"


// CDialogConfigTab5 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab5, CDialog)

CDialogConfigTab5::CDialogConfigTab5(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab5::IDD, pParent)
{
	m_isDoCommand = FALSE;
}

CDialogConfigTab5::~CDialogConfigTab5()
{
}

void CDialogConfigTab5::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_GSensorRegIndex);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_GSensorData);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_WriteGSensorData);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_DATAX);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_DATAY);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_DATAZ);
	DDX_Control(pDX, IDC_LIST1, m_CListCtrl_GSensor);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab5, CDialog)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab5::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab5::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab5::OnBnClickedButton3)
END_MESSAGE_MAP()


// CDialogConfigTab5 TBz`

BOOL CDialogConfigTab5::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_GSensorRegIndex.ResetContent();
	m_CComboBox_GSensorRegIndex.InsertString(0, TEXT("00 : DEVID"));
	m_CComboBox_GSensorRegIndex.InsertString(1, TEXT("29 : THRESH_TAP"));
	m_CComboBox_GSensorRegIndex.InsertString(2, TEXT("30 : OFSX"));
	m_CComboBox_GSensorRegIndex.InsertString(3, TEXT("31 : OFSY"));
	m_CComboBox_GSensorRegIndex.InsertString(4, TEXT("32 : OFSZ"));
	m_CComboBox_GSensorRegIndex.InsertString(5, TEXT("33 : DUR"));
	m_CComboBox_GSensorRegIndex.InsertString(6, TEXT("34 : Latent"));
	m_CComboBox_GSensorRegIndex.InsertString(7, TEXT("35 : Window"));
	m_CComboBox_GSensorRegIndex.InsertString(8, TEXT("36 : THRESH_ACT"));
	m_CComboBox_GSensorRegIndex.InsertString(9, TEXT("37 : THRESH_INACT"));
	m_CComboBox_GSensorRegIndex.InsertString(10, TEXT("38 : TIME_INACT"));
	m_CComboBox_GSensorRegIndex.InsertString(11, TEXT("39 : ACT_INACT_CTL"));
	m_CComboBox_GSensorRegIndex.InsertString(12, TEXT("40 : THRESH_FF"));
	m_CComboBox_GSensorRegIndex.InsertString(13, TEXT("41 : TIME_FF"));
	m_CComboBox_GSensorRegIndex.InsertString(14, TEXT("42 : TAP_AXES"));
	m_CComboBox_GSensorRegIndex.InsertString(15, TEXT("43 : ACT_TAP_STATUS"));
	m_CComboBox_GSensorRegIndex.InsertString(16, TEXT("44 : BW_RATE"));
	m_CComboBox_GSensorRegIndex.InsertString(17, TEXT("45 : POWER_CTL"));
	m_CComboBox_GSensorRegIndex.InsertString(18, TEXT("46 : INT_ENABLE"));
	m_CComboBox_GSensorRegIndex.InsertString(19, TEXT("47 : INT_MAP"));
	m_CComboBox_GSensorRegIndex.InsertString(20, TEXT("48 : INT_SOURCE"));
	m_CComboBox_GSensorRegIndex.InsertString(21, TEXT("49 : DATA_FORMAT"));
	m_CComboBox_GSensorRegIndex.InsertString(22, TEXT("50 : DATA_X0"));
	m_CComboBox_GSensorRegIndex.InsertString(23, TEXT("51 : DATA_X1"));
	m_CComboBox_GSensorRegIndex.InsertString(24, TEXT("52 : DATA_Y0"));
	m_CComboBox_GSensorRegIndex.InsertString(25, TEXT("53 : DATA_Y1"));
	m_CComboBox_GSensorRegIndex.InsertString(26, TEXT("54 : DATA_Z0"));
	m_CComboBox_GSensorRegIndex.InsertString(27, TEXT("55 : DATA_Z1"));
	m_CComboBox_GSensorRegIndex.InsertString(28, TEXT("56 : FIFO_CTL"));
	m_CComboBox_GSensorRegIndex.InsertString(29, TEXT("57 : FIFO_STATUS"));
	m_CComboBox_GSensorRegIndex.SetCurSel(17);

	m_CEdit_WriteGSensorData.SetWindowText(TEXT("0A"));

	m_CListCtrl_GSensor.DeleteAllItems();
	m_CListCtrl_GSensor.InsertColumn(0, TEXT("Num"));
	m_CListCtrl_GSensor.InsertColumn(1, TEXT("Name"));
	m_CListCtrl_GSensor.InsertColumn(2, TEXT("Type"));
	m_CListCtrl_GSensor.InsertColumn(3, TEXT("Value"));
	m_CListCtrl_GSensor.InsertColumn(4, TEXT("Description"));
	m_CListCtrl_GSensor.SetColumnWidth(0, 40);
	m_CListCtrl_GSensor.SetColumnWidth(1, 110);
	m_CListCtrl_GSensor.SetColumnWidth(2, 40);
	m_CListCtrl_GSensor.SetColumnWidth(3, 40);
	m_CListCtrl_GSensor.SetColumnWidth(4, 300);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab5::OnTimer(UINT_PTR nIDEvent)
{
	if( 1 == nIDEvent )
	{
		KillTimer(1);

		switch( m_nStep )
		{
		case 0: fnSetGsensorData();		m_nStep++; break;
		case 1: fnGetGsensorData();		m_nStep++; break;
		case 2: fnGetAllGsensorData();	m_nStep++; break;
		default: break;
		}

		if( m_nStep < 3 )
			SetTimer(1, 100, NULL);
		else
			SetTimer(2, 200, NULL);
	}

	if( 2 == nIDEvent )
	{
		KillTimer(2);

		if( IsWindowVisible() )
		{
			fnGetGsensorDataXYZ();
		}

		SetTimer(2, 200, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}

BYTE GetAddress(int nIndex)
{
	BYTE byAddress = 0;
	if( nIndex == 0 )
		byAddress = 0;
	else
		byAddress = nIndex + 0x1C;

	if( byAddress < 0 && byAddress > 0x39 )
		byAddress = 0;

	return byAddress;
}

TCHAR g_szName[][20] = {
						TEXT("DEVID"),
						TEXT("Reserved"),
						TEXT("THRESH_TAP"),
						TEXT("OFSX"),
						TEXT("OFSY"),
						TEXT("OFSZ"),
						TEXT("DUR"),
						TEXT("Latent"),
						TEXT("Window"),
						TEXT("THRESH_ACT"),
						TEXT("THRESH_INACT"),
						TEXT("TIME_INACT"),
						TEXT("ACT_INACT_CTL"),
						TEXT("THRESH_FF"),
						TEXT("TIME_FF"),
						TEXT("TAP_AXES"),
						TEXT("ACT_TAP_STATUS"),
						TEXT("BW_RATE"),
						TEXT("POWER_CTL"),
						TEXT("INT_ENABLE"),
						TEXT("INT_MAP"),
						TEXT("INT_SOURCE"),
						TEXT("DATA_FORMAT"),
						TEXT("DATAX0"),
						TEXT("DATAX1"),
						TEXT("DATAY0"),
						TEXT("DATAY1"),
						TEXT("DATAZ0"),
						TEXT("DATAZ1"),
						TEXT("FIFO_CTL"),
						TEXT("FIFO_STATUS")};

TCHAR g_szType[][5] = {
						TEXT("R"),
						TEXT(""),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R/W"),
						TEXT("R"),
						TEXT("R/W"),
						TEXT("R"),
						TEXT("R"),
						TEXT("R"),
						TEXT("R"),
						TEXT("R"),
						TEXT("R"),
						TEXT("R/W"),
						TEXT("R")};

TCHAR g_szDescription[][60] = {
						TEXT("Device ID"),
						TEXT("Reserved; do not access"),
						TEXT("Tap threshold"),
						TEXT("X-axis offset"),
						TEXT("Y-axis offset"),
						TEXT("Z-axis offset"),
						TEXT("Tap duration"),
						TEXT("Tap latency"),
						TEXT("Tap window"),
						TEXT("Activity threshold"),
						TEXT("Inactivity threshold"),
						TEXT("Inactivity time"),
						TEXT("Axis enable control for activity and inactivity detection"),
						TEXT("Free-fall threshold"),
						TEXT("Free-fall time"),
						TEXT("Axis control for single tap/double tap"),
						TEXT("Source of single tap/double tap"),
						TEXT("Data rate and power mode control"),
						TEXT("Power-saving features control"),
						TEXT("Interrupt enable control"),
						TEXT("Interrupt mapping control"),
						TEXT("Source of interrupts"),
						TEXT("Data format control"),
						TEXT("X-Axis Data 0"),
						TEXT("X-Axis Data 1"),
						TEXT("Y-Axis Data 0"),
						TEXT("Y-Axis Data 1"),
						TEXT("Z-Axis Data 0"),
						TEXT("Z-Axis Data 1"),
						TEXT("FIFO control"),
						TEXT("FIFO status")};

void CDialogConfigTab5::fnSetGsensorData()
{
	unsigned char byData = 0x0;

	char szData[8];
	memset(szData, 0, sizeof(szData));

	::GetWindowTextA(m_CEdit_WriteGSensorData.GetSafeHwnd(), szData, sizeof(szData));
	byData = transfer_string_to_hex( (unsigned char*)szData );

	BYTE byRegIdx = GetAddress(m_CComboBox_GSensorRegIndex.GetCurSel());
	
	int nResult = SetGsensorData(byRegIdx, &byData, 1);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Gsensor Data Success."));
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Gsensor Data Failed!!!"));
	}
}

void CDialogConfigTab5::fnGetGsensorData()
{
	BYTE byRegIdx = GetAddress(m_CComboBox_GSensorRegIndex.GetCurSel());

	unsigned int nDataLen = 1;
	unsigned char byGsensorData[128];
	memset(byGsensorData, 0, sizeof(byGsensorData));

	int nResult = GetGsensorData(byRegIdx, byGsensorData, nDataLen);
	if( nResult == 1 )
	{
		CString strGsensorData;
		CString strTemp;
		for (unsigned int i=0 ; i<nDataLen && i<128 ; i++)
		{
			strTemp.Format(TEXT("%02X "), byGsensorData[i]);
			strGsensorData += strTemp;  
		}

		m_CEdit_GSensorData.SetWindowText(strGsensorData);
	}
	else
	{
		m_CEdit_GSensorData.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab5::fnGetAllGsensorData()
{
	m_CListCtrl_GSensor.DeleteAllItems();
	m_CListCtrl_GSensor.UpdateWindow();

	unsigned char byGsensorData[128];
	memset(byGsensorData, 0, sizeof(byGsensorData));

	int nResult = GetGsensorData(0, byGsensorData, 1);
	if( nResult == 1 )
	{
		CString strGsensorData;
		strGsensorData.Format(TEXT("%02X "), byGsensorData[0]);

		m_CListCtrl_GSensor.InsertItem( 0, TEXT("0") );
		m_CListCtrl_GSensor.SetItemText( 0, 1, g_szName[0] );
		m_CListCtrl_GSensor.SetItemText( 0, 2, g_szType[0] );
		m_CListCtrl_GSensor.SetItemText( 0, 3, strGsensorData );
		m_CListCtrl_GSensor.SetItemText( 0, 4, g_szDescription[0] );

		m_CListCtrl_GSensor.InsertItem( 1, TEXT("1~28") );
		m_CListCtrl_GSensor.SetItemText( 1, 1, g_szName[1] );
		m_CListCtrl_GSensor.SetItemText( 1, 2, g_szType[1] );
		m_CListCtrl_GSensor.SetItemText( 1, 3, TEXT("") );
		m_CListCtrl_GSensor.SetItemText( 1, 4, g_szDescription[1] );

		memset(byGsensorData, 0, sizeof(byGsensorData));
		nResult = GetGsensorData(29, byGsensorData, 29);
		if( nResult == 1 )
		{
			for ( int i=0 ; i<29 ; i++ )
			{
				CString strNum;
				strNum.Format(TEXT("%d"), i+29);

				CString strGsensorData;
				strGsensorData.Format(TEXT("%02X "), byGsensorData[i]);

				m_CListCtrl_GSensor.InsertItem( i+2, strNum );
				m_CListCtrl_GSensor.SetItemText( i+2, 1, g_szName[i+2] );
				m_CListCtrl_GSensor.SetItemText( i+2, 2, g_szType[i+2] );
				m_CListCtrl_GSensor.SetItemText( i+2, 3, strGsensorData );
				m_CListCtrl_GSensor.SetItemText( i+2, 4, g_szDescription[i+2] );
			}

			CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
			if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Get all Gsensor Data Success."));

			return;
		}
	}
	
	CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
	if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Get all Gsensor Data Failed!!!"));
}

void CDialogConfigTab5::fnGetGsensorDataXYZ()
{
	unsigned char byGsensorData[7];
	memset(byGsensorData, 0, sizeof(byGsensorData));

	int nResult = GetGsensorData(50, byGsensorData, 6);
	if( nResult == 1 )
	{
		CString strDataX;
		strDataX.Format(TEXT("%d"), (short)(byGsensorData[0] | (byGsensorData[1] << 8)));

		CString strDataY;
		strDataY.Format(TEXT("%d"), (short)(byGsensorData[2] | (byGsensorData[3] << 8)));

		CString strDataZ;
		strDataZ.Format(TEXT("%d"), (short)(byGsensorData[4] | (byGsensorData[5] << 8)));

		m_CEdit_DATAX.SetWindowText(strDataX);
		m_CEdit_DATAY.SetWindowText(strDataY);
		m_CEdit_DATAZ.SetWindowText(strDataZ);
	}
}

void CDialogConfigTab5::OnBnClickedButton1()
{
	fnGetGsensorData();
}

void CDialogConfigTab5::OnBnClickedButton2()
{
	fnSetGsensorData();
}

void CDialogConfigTab5::OnBnClickedButton3()
{
	fnGetAllGsensorData();
}

void CDialogConfigTab5::DoCommand()
{
	if( FALSE == m_isDoCommand )
	{
		m_isDoCommand = TRUE;
		m_nStep = 0;
		SetTimer(1, 0, NULL);
	}
}
