// DialogConfigTab4.cpp : @
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "DialogConfigTab4.h"
#include "VTC6221.h"
#include "VTC6221_UtilityDlg.h"


// CDialogConfigTab4 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab4, CDialog)

CDialogConfigTab4::CDialogConfigTab4(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab4::IDD, pParent)
{
	m_isDoCommand = FALSE;
}

CDialogConfigTab4::~CDialogConfigTab4()
{
}

void CDialogConfigTab4::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_WWAN1);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_WWAN2);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_WWAN3);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_WWAN3Wakeup);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_WWAN4);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_WWAN1);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_WWAN2);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_WWAN3);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_WWAN3Wakeup);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_WWAN4);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_WiFi_1);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_WiFi_1);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_WiFi_2);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_WiFi_2);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_WiFi_3);
	DDX_Control(pDX, IDC_COMBO8, m_CComboBox_WiFi_3);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_BT1);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_BT2);
	DDX_Control(pDX, IDC_EDIT11, m_CEdit_BT3);
	DDX_Control(pDX, IDC_COMBO9, m_CComboBox_BT1);
	DDX_Control(pDX, IDC_COMBO10, m_CComboBox_BT2);
	DDX_Control(pDX, IDC_COMBO11, m_CComboBox_BT3);
	DDX_Control(pDX, IDC_EDIT12, m_CEdit_GPS_Status);
	DDX_Control(pDX, IDC_COMBO12, m_CComboBox_GPS_Enable);
	DDX_Control(pDX, IDC_EDIT13, m_CEdit_SIMCard1);
	DDX_Control(pDX, IDC_EDIT14, m_CEdit_SIMCard2);
	DDX_Control(pDX, IDC_EDIT15, m_CEdit_SIMCard3);
	DDX_Control(pDX, IDC_EDIT16, m_CEdit_SIMCard4);
	DDX_Control(pDX, IDC_COMBO13, m_CComboBox_SIMCard1);
	DDX_Control(pDX, IDC_COMBO14, m_CComboBox_SIMCard2);
	DDX_Control(pDX, IDC_COMBO15, m_CComboBox_SIMCard3);
	DDX_Control(pDX, IDC_COMBO16, m_CComboBox_SIMCard4);
	DDX_Control(pDX, IDC_STATIC1, m_CStatic_WWAN1);
	DDX_Control(pDX, IDC_STATIC3, m_CStatic_WWAN3);
	DDX_Control(pDX, IDC_STATIC5, m_CStatic_WWAN4);
	DDX_Control(pDX, IDC_STATIC6, m_CStatic_SIMCard1);
	DDX_Control(pDX, IDC_STATIC8, m_CStatic_SIMCard3);
	DDX_Control(pDX, IDC_STATIC9, m_CStatic_SIMCard4);
	DDX_Control(pDX, IDC_STATIC10, m_CStatic_WiFi_1);
	DDX_Control(pDX, IDC_STATIC11, m_CStatic_WiFi_2);
	DDX_Control(pDX, IDC_STATIC12, m_CStatic_WiFi_3);
	DDX_Control(pDX, IDC_STATIC13, m_CStatic_BT1);
	DDX_Control(pDX, IDC_STATIC14, m_CStatic_BT2);
	DDX_Control(pDX, IDC_STATIC15, m_CStatic_BT3);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab4, CDialog)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab4::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab4::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab4::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDialogConfigTab4::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CDialogConfigTab4::OnBnClickedButton5)
END_MESSAGE_MAP()


// CDialogConfigTab4 TBz`

BOOL CDialogConfigTab4::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_WWAN1.ResetContent();
	m_CComboBox_WWAN1.InsertString(0, TEXT("Disable"));
	m_CComboBox_WWAN1.InsertString(1, TEXT("Enable"));
	m_CComboBox_WWAN1.SetCurSel(1);

	m_CComboBox_WWAN2.ResetContent();
	m_CComboBox_WWAN2.InsertString(0, TEXT("Disable"));
	m_CComboBox_WWAN2.InsertString(1, TEXT("Enable"));
	m_CComboBox_WWAN2.SetCurSel(1);

	m_CComboBox_WWAN3.ResetContent();
	m_CComboBox_WWAN3.InsertString(0, TEXT("Disable"));
	m_CComboBox_WWAN3.InsertString(1, TEXT("Enable"));
	m_CComboBox_WWAN3.SetCurSel(1);

	m_CComboBox_WWAN3Wakeup.ResetContent();
	m_CComboBox_WWAN3Wakeup.InsertString(0, TEXT("Disable"));
	m_CComboBox_WWAN3Wakeup.InsertString(1, TEXT("Enable"));
	m_CComboBox_WWAN3Wakeup.SetCurSel(0);

	m_CComboBox_WWAN4.ResetContent();
	m_CComboBox_WWAN4.InsertString(0, TEXT("Disable"));
	m_CComboBox_WWAN4.InsertString(1, TEXT("Enable"));
	m_CComboBox_WWAN4.SetCurSel(1);

	m_CComboBox_WiFi_1.ResetContent();
	m_CComboBox_WiFi_1.InsertString(0, TEXT("Disable"));
	m_CComboBox_WiFi_1.InsertString(1, TEXT("Enable"));
	m_CComboBox_WiFi_1.SetCurSel(1);

	m_CComboBox_WiFi_2.ResetContent();
	m_CComboBox_WiFi_2.InsertString(0, TEXT("Disable"));
	m_CComboBox_WiFi_2.InsertString(1, TEXT("Enable"));
	m_CComboBox_WiFi_2.SetCurSel(1);

	m_CComboBox_WiFi_3.ResetContent();
	m_CComboBox_WiFi_3.InsertString(0, TEXT("Disable"));
	m_CComboBox_WiFi_3.InsertString(1, TEXT("Enable"));
	m_CComboBox_WiFi_3.SetCurSel(1);

	m_CComboBox_BT1.ResetContent();
	m_CComboBox_BT1.InsertString(0, TEXT("Disable"));
	m_CComboBox_BT1.InsertString(1, TEXT("Enable"));
	m_CComboBox_BT1.SetCurSel(1);

	m_CComboBox_BT2.ResetContent();
	m_CComboBox_BT2.InsertString(0, TEXT("Disable"));
	m_CComboBox_BT2.InsertString(1, TEXT("Enable"));
	m_CComboBox_BT2.SetCurSel(1);

	m_CComboBox_BT3.ResetContent();
	m_CComboBox_BT3.InsertString(0, TEXT("Disable"));
	m_CComboBox_BT3.InsertString(1, TEXT("Enable"));
	m_CComboBox_BT3.SetCurSel(1);

	m_CComboBox_GPS_Enable.ResetContent();
	m_CComboBox_GPS_Enable.InsertString(0, TEXT("Disable"));
	m_CComboBox_GPS_Enable.InsertString(1, TEXT("Enable"));
	m_CComboBox_GPS_Enable.SetCurSel(1);

	m_CComboBox_SIMCard1.ResetContent();
	m_CComboBox_SIMCard1.InsertString(0, TEXT("SIM Card 1"));
	m_CComboBox_SIMCard1.InsertString(1, TEXT("SIM Card 2"));
	m_CComboBox_SIMCard1.SetCurSel(0);

	m_CComboBox_SIMCard2.ResetContent();
	m_CComboBox_SIMCard2.InsertString(0, TEXT("SIM Card 1"));
	m_CComboBox_SIMCard2.InsertString(1, TEXT("SIM Card 2"));
	m_CComboBox_SIMCard2.SetCurSel(0);

	m_CComboBox_SIMCard3.ResetContent();
	m_CComboBox_SIMCard3.InsertString(0, TEXT("SIM Card 1"));
	m_CComboBox_SIMCard3.InsertString(1, TEXT("SIM Card 2"));
	m_CComboBox_SIMCard3.SetCurSel(0);

	m_CComboBox_SIMCard4.ResetContent();
	m_CComboBox_SIMCard4.InsertString(0, TEXT("SIM Card 1"));
	m_CComboBox_SIMCard4.InsertString(1, TEXT("SIM Card 2"));
	m_CComboBox_SIMCard4.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab4::OnTimer(UINT_PTR nIDEvent)
{
	if( 1 == nIDEvent )
	{
		KillTimer(1);

		switch( m_nStep )
		{
		case 0:  fnGetWWANStatus();		m_nStep++; break;
		case 1:  fnGetWiFiStatus();		m_nStep++; break;
		case 2:  fnGetBTStatus();		m_nStep++; break;
		case 3:  fnGetGPSStatus();		m_nStep++; break;
		case 4:  fnGetSIMCardStatus();	m_nStep++; break;
		case 5:  fnGetPCIESlotMode();	m_nStep++; break;
		default: break;
		}

		if( m_nStep < 6 )
			SetTimer(1, 100, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}

void CDialogConfigTab4::fnGetWWANStatus()
{
	int nWWAN_Enable = 0;
	int nWWAN_Enable2 = 0;
	int nWWAN_Enable3 = 0;
	int nWWAN_Wakeup_Enable3 = 0;
	int nWWAN_Enable4 = 0;

	int nResult = GetWWANStatus(&nWWAN_Enable, &nWWAN_Enable2, &nWWAN_Enable3, &nWWAN_Wakeup_Enable3, &nWWAN_Enable4);
	if( nResult == 1 )
	{
		switch(nWWAN_Enable)
		{
		case 0: m_CEdit_WWAN1.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WWAN1.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WWAN1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nWWAN_Enable2)
		{
		case 0: m_CEdit_WWAN2.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WWAN2.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WWAN2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nWWAN_Enable3)
		{
		case 0: m_CEdit_WWAN3.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WWAN3.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WWAN3.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nWWAN_Wakeup_Enable3)
		{
		case 0: m_CEdit_WWAN3Wakeup.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WWAN3Wakeup.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WWAN3Wakeup.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nWWAN_Enable4)
		{
		case 0: m_CEdit_WWAN4.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WWAN4.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WWAN4.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_WWAN1.SetWindowText(TEXT("?"));
		m_CEdit_WWAN2.SetWindowText(TEXT("?"));
		m_CEdit_WWAN3.SetWindowText(TEXT("?"));
		m_CEdit_WWAN3Wakeup.SetWindowText(TEXT("?"));
		m_CEdit_WWAN4.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab4::fnGetWiFiStatus()
{
	int nWiFi_En1 = 0;
	int nWiFi_En2 = 0;
	int nWiFi_En3 = 0;
	int nWiFi_Pw1 = 1; // Power on/off is used for USB module only.
	int nWiFi_Pw2 = 1; // Power on/off is used for USB module only.
	int nWiFi_Pw3 = 1; // Power on/off is used for USB module only.

	int nResult = GetWiFiStatus(&nWiFi_En1, &nWiFi_En2, &nWiFi_En3, &nWiFi_Pw1, &nWiFi_Pw2, &nWiFi_Pw3);
	if( nResult == 1 )
	{
		switch(nWiFi_En1)
		{
		case 0: m_CEdit_WiFi_1.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WiFi_1.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WiFi_1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nWiFi_En2)
		{
		case 0: m_CEdit_WiFi_2.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WiFi_2.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WiFi_2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nWiFi_En3)
		{
		case 0: m_CEdit_WiFi_3.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_WiFi_3.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_WiFi_3.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_WiFi_1.SetWindowText(TEXT("?"));
		m_CEdit_WiFi_2.SetWindowText(TEXT("?"));
		m_CEdit_WiFi_3.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab4::fnGetBTStatus()
{
	int nBTStatus1 = 0;
	int nBTStatus2 = 0;
	int nBTStatus3 = 0;

	int nResult = GetBTStatus(&nBTStatus1, &nBTStatus2, &nBTStatus3);
	if( nResult == 1 )
	{
		switch(nBTStatus1)
		{
		case 0: m_CEdit_BT1.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_BT1.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_BT1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nBTStatus2)
		{
		case 0: m_CEdit_BT2.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_BT2.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_BT2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nBTStatus3)
		{
		case 0: m_CEdit_BT3.SetWindowText(TEXT("Disable")); break;
		case 1: m_CEdit_BT3.SetWindowText(TEXT("Enable")); break;
		default: m_CEdit_BT3.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_BT1.SetWindowText(TEXT("?"));
		m_CEdit_BT2.SetWindowText(TEXT("?"));
		m_CEdit_BT3.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab4::fnGetGPSStatus()
{
	int nGPSStatus;
	int nResult = GetGPSStatus(&nGPSStatus);
	if( nResult == 1 )
	{
		CString strGPSStatus;
		switch(nGPSStatus)
		{
		case 0: strGPSStatus = TEXT("Disable"); break;
		case 1: strGPSStatus = TEXT("Enable"); break;
		default: strGPSStatus = TEXT("Undefined"); break;
		}
		m_CEdit_GPS_Status.SetWindowText(strGPSStatus);
	}
	else
	{
		m_CEdit_GPS_Status.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab4::fnGetSIMCardStatus()
{
	int nSIMCard1 = 0;
	int nSIMCard2 = 0;
	int nSIMCard3 = 0;
	int nSIMCard4 = 0;

	int nResult = GetSIMCardStatus(&nSIMCard1, &nSIMCard2, &nSIMCard3, &nSIMCard4);
	if( nResult == 1 )
	{
		switch(nSIMCard1)
		{
		case 0: m_CEdit_SIMCard1.SetWindowText(TEXT("SIM Card 1")); break;
		case 1: m_CEdit_SIMCard1.SetWindowText(TEXT("SIM Card 2")); break;
		default: m_CEdit_SIMCard1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nSIMCard2)
		{
		case 0: m_CEdit_SIMCard2.SetWindowText(TEXT("SIM Card 1")); break;
		case 1: m_CEdit_SIMCard2.SetWindowText(TEXT("SIM Card 2")); break;
		default: m_CEdit_SIMCard2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nSIMCard3)
		{
		case 0: m_CEdit_SIMCard3.SetWindowText(TEXT("SIM Card 1")); break;
		case 1: m_CEdit_SIMCard3.SetWindowText(TEXT("SIM Card 2")); break;
		default: m_CEdit_SIMCard3.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nSIMCard4)
		{
		case 0: m_CEdit_SIMCard4.SetWindowText(TEXT("SIM Card 1")); break;
		case 1: m_CEdit_SIMCard4.SetWindowText(TEXT("SIM Card 2")); break;
		default: m_CEdit_SIMCard4.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_SIMCard1.SetWindowText(TEXT("?"));
		m_CEdit_SIMCard2.SetWindowText(TEXT("?"));
		m_CEdit_SIMCard3.SetWindowText(TEXT("?"));
		m_CEdit_SIMCard4.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab4::fnGetPCIESlotMode()
{
	int nCN5 = 0;
	int nCN23 = 1;

	if( GetPCIESlotMode(&nCN5, &nCN23) == 1 )
	{
		if( nCN5 == 1 )
		{ // 1: WIFI#3
			m_CStatic_WWAN1.ShowWindow(FALSE);
			m_CEdit_WWAN1.ShowWindow(FALSE);
			m_CComboBox_WWAN1.ShowWindow(FALSE);

			m_CStatic_SIMCard1.ShowWindow(FALSE);
			m_CEdit_SIMCard1.ShowWindow(FALSE);
			m_CComboBox_SIMCard1.ShowWindow(FALSE);

			m_CStatic_WiFi_3.ShowWindow(TRUE);
			m_CEdit_WiFi_3.ShowWindow(TRUE);
			m_CComboBox_WiFi_3.ShowWindow(TRUE);

			m_CStatic_BT3.ShowWindow(TRUE);
			m_CEdit_BT3.ShowWindow(TRUE);
			m_CComboBox_BT3.ShowWindow(TRUE);
		}
		else
		{ // 0: WWAN#1(default)
			m_CStatic_WWAN1.ShowWindow(TRUE);
			m_CEdit_WWAN1.ShowWindow(TRUE);
			m_CComboBox_WWAN1.ShowWindow(TRUE);

			m_CStatic_SIMCard1.ShowWindow(TRUE);
			m_CEdit_SIMCard1.ShowWindow(TRUE);
			m_CComboBox_SIMCard1.ShowWindow(TRUE);

			m_CStatic_WiFi_3.ShowWindow(FALSE);
			m_CEdit_WiFi_3.ShowWindow(FALSE);
			m_CComboBox_WiFi_3.ShowWindow(FALSE);

			m_CStatic_BT3.ShowWindow(FALSE);
			m_CEdit_BT3.ShowWindow(FALSE);
			m_CComboBox_BT3.ShowWindow(FALSE);
		}

		if( nCN23 == 1 )
		{ // 1: WIFI#2 (default)
			m_CStatic_WWAN4.ShowWindow(FALSE);
			m_CEdit_WWAN4.ShowWindow(FALSE);
			m_CComboBox_WWAN4.ShowWindow(FALSE);

			m_CStatic_SIMCard4.ShowWindow(FALSE);
			m_CEdit_SIMCard4.ShowWindow(FALSE);
			m_CComboBox_SIMCard4.ShowWindow(FALSE);

			m_CStatic_WiFi_2.ShowWindow(TRUE);
			m_CEdit_WiFi_2.ShowWindow(TRUE);
			m_CComboBox_WiFi_2.ShowWindow(TRUE);

			m_CStatic_BT2.ShowWindow(TRUE);
			m_CEdit_BT2.ShowWindow(TRUE);
			m_CComboBox_BT2.ShowWindow(TRUE);
		}
		else
		{ // 0: WWAN#4
			m_CStatic_WWAN4.ShowWindow(TRUE);
			m_CEdit_WWAN4.ShowWindow(TRUE);
			m_CComboBox_WWAN4.ShowWindow(TRUE);

			m_CStatic_SIMCard4.ShowWindow(TRUE);
			m_CEdit_SIMCard4.ShowWindow(TRUE);
			m_CComboBox_SIMCard4.ShowWindow(TRUE);

			m_CStatic_WiFi_2.ShowWindow(FALSE);
			m_CEdit_WiFi_2.ShowWindow(FALSE);
			m_CComboBox_WiFi_2.ShowWindow(FALSE);

			m_CStatic_BT2.ShowWindow(FALSE);
			m_CEdit_BT2.ShowWindow(FALSE);
			m_CComboBox_BT2.ShowWindow(FALSE);
		}
	}
}

void CDialogConfigTab4::OnBnClickedButton1()
{
	int nWWAN_Enable = m_CComboBox_WWAN1.GetCurSel();
	int nWWAN_Enable2 = m_CComboBox_WWAN2.GetCurSel();
	int nWWAN_Enable3 = m_CComboBox_WWAN3.GetCurSel();
	int nWWAN_Wakeup_Enable3 = m_CComboBox_WWAN3Wakeup.GetCurSel();
	int nWWAN_Enable4 = m_CComboBox_WWAN4.GetCurSel();

	int nResult = SetWWANControl(nWWAN_Enable, nWWAN_Enable2, nWWAN_Enable3, nWWAN_Wakeup_Enable3, nWWAN_Enable4);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set WWAN Control success."));

		fnGetWWANStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set WWAN Control failed!!!"));
	}
}

void CDialogConfigTab4::OnBnClickedButton2()
{
	int nWiFi_En1 = m_CComboBox_WiFi_1.GetCurSel();
	int nWiFi_En2 = m_CComboBox_WiFi_2.GetCurSel();
	int nWiFi_En3 = m_CComboBox_WiFi_3.GetCurSel();
	int nWiFi_Pw1 = 1; // Power on/off is used for USB module only.
	int nWiFi_Pw2 = 1; // Power on/off is used for USB module only.
	int nWiFi_Pw3 = 1; // Power on/off is used for USB module only.

	int nResult = SetWiFiControl(nWiFi_En1, nWiFi_En2, nWiFi_En3, nWiFi_Pw1, nWiFi_Pw2, nWiFi_Pw3);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set WiFi Control success."));

		fnGetWiFiStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set WiFi Control failed!!!"));
	}
}

void CDialogConfigTab4::OnBnClickedButton3()
{
	int nBT1 = m_CComboBox_BT1.GetCurSel();
	int nBT2 = m_CComboBox_BT2.GetCurSel();
	int nBT3 = m_CComboBox_BT3.GetCurSel();

	int nResult = SetBTControl(nBT1, nBT2, nBT3);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set BT Control success."));

		fnGetBTStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set BT Control failed!!!"));
	}
}

void CDialogConfigTab4::OnBnClickedButton4()
{
	int nGPS_Enable  = m_CComboBox_GPS_Enable.GetCurSel();
	int nResult = SetGPSControl(nGPS_Enable);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPS Control success."));

		fnGetGPSStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPS Control failed!!!"));
	}
}

void CDialogConfigTab4::OnBnClickedButton5()
{
	int nSIMCardSelect1 = m_CComboBox_SIMCard1.GetCurSel();
	int nSIMCardSelect2 = m_CComboBox_SIMCard2.GetCurSel();
	int nSIMCardSelect3 = m_CComboBox_SIMCard3.GetCurSel();
	int nSIMCardSelect4 = m_CComboBox_SIMCard4.GetCurSel();

	int nResult = SetSIMCardSelect(nSIMCardSelect1, nSIMCardSelect2, nSIMCardSelect3, nSIMCardSelect4);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set SIM Card Select Success."));

		fnGetSIMCardStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set SIM Card Select Failed!!!"));
	}
}

void CDialogConfigTab4::DoCommand()
{
	if( FALSE == m_isDoCommand )
	{
		m_isDoCommand = TRUE;
		m_nStep = 0;
		SetTimer(1, 0, NULL);
	}
}

void CDialogConfigTab4::ResetDoCommand()
{
	m_isDoCommand = FALSE;
}
