// DialogConfigTab3.cpp : @
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "DialogConfigTab3.h"
#include "VTC6221.h"
#include "VTC6221_UtilityDlg.h"


// CDialogConfigTab3 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab3, CDialog)

CDialogConfigTab3::CDialogConfigTab3(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab3::IDD, pParent)
{
	m_isDoCommand = FALSE;
}

CDialogConfigTab3::~CDialogConfigTab3()
{
}

void CDialogConfigTab3::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_GPO1_Status);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_SetGPO1);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_GPO2_Status);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_SetGPO2);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_GPO3_Status);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_SetGPO3);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_GPO4_Status);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_SetGPO4);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_GPI1);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_GPI2);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_GPI3);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_GPI4);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_ProgramLED1);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_ProgramLED1);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_ProgramLED2);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_ProgramLED2);
	DDX_Control(pDX, IDC_EDIT11, m_CEdit_ProgramLED3);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_ProgramLED3);
	DDX_Control(pDX, IDC_EDIT12, m_CEdit_ProgramLED_Alarm);
	DDX_Control(pDX, IDC_COMBO8, m_CComboBox_ProgramLED_Alarm);
	DDX_Control(pDX, IDC_EDIT13, m_CEdit_WakeOnLan);
	DDX_Control(pDX, IDC_COMBO9, m_CComboBox_WakeOnLan);
	DDX_Control(pDX, IDC_EDIT14, m_CEdit_External12V);
	DDX_Control(pDX, IDC_COMBO10, m_CComboBox_External12V);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab3, CDialog)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab3::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab3::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab3::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDialogConfigTab3::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CDialogConfigTab3::OnBnClickedButton5)
END_MESSAGE_MAP()


// CDialogConfigTab3 TBz`

BOOL CDialogConfigTab3::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_SetGPO1.ResetContent();
	m_CComboBox_SetGPO1.InsertString(0, TEXT("Low"));
	m_CComboBox_SetGPO1.InsertString(1, TEXT("High"));
	m_CComboBox_SetGPO1.SetCurSel(1);

	m_CComboBox_SetGPO2.ResetContent();
	m_CComboBox_SetGPO2.InsertString(0, TEXT("Low"));
	m_CComboBox_SetGPO2.InsertString(1, TEXT("High"));
	m_CComboBox_SetGPO2.SetCurSel(1);

	m_CComboBox_SetGPO3.ResetContent();
	m_CComboBox_SetGPO3.InsertString(0, TEXT("Low"));
	m_CComboBox_SetGPO3.InsertString(1, TEXT("High"));
	m_CComboBox_SetGPO3.SetCurSel(1);

	m_CComboBox_SetGPO4.ResetContent();
	m_CComboBox_SetGPO4.InsertString(0, TEXT("Low"));
	m_CComboBox_SetGPO4.InsertString(1, TEXT("High"));
	m_CComboBox_SetGPO4.SetCurSel(1);

	m_CComboBox_WakeOnLan.ResetContent();
	m_CComboBox_WakeOnLan.InsertString(0, TEXT("Disable"));
	m_CComboBox_WakeOnLan.InsertString(1, TEXT("Enable"));
	m_CComboBox_WakeOnLan.SetCurSel(0);

	m_CComboBox_External12V.ResetContent();
	m_CComboBox_External12V.InsertString(0, TEXT("Disable"));
	m_CComboBox_External12V.InsertString(1, TEXT("Enable"));
	m_CComboBox_External12V.SetCurSel(0);

	m_CComboBox_ProgramLED1.ResetContent();
	m_CComboBox_ProgramLED1.InsertString(0, TEXT("OFF"));
	m_CComboBox_ProgramLED1.InsertString(1, TEXT("Orange"));
	m_CComboBox_ProgramLED1.InsertString(2, TEXT("Green"));
	m_CComboBox_ProgramLED1.SetCurSel(0);

	m_CComboBox_ProgramLED2.ResetContent();
	m_CComboBox_ProgramLED2.InsertString(0, TEXT("OFF"));
	m_CComboBox_ProgramLED2.InsertString(1, TEXT("Orange"));
	m_CComboBox_ProgramLED2.InsertString(2, TEXT("Green"));
	m_CComboBox_ProgramLED2.SetCurSel(0);

	m_CComboBox_ProgramLED3.ResetContent();
	m_CComboBox_ProgramLED3.InsertString(0, TEXT("OFF"));
	m_CComboBox_ProgramLED3.InsertString(1, TEXT("ON"));
	m_CComboBox_ProgramLED3.SetCurSel(0);

	m_CComboBox_ProgramLED_Alarm.ResetContent();
	m_CComboBox_ProgramLED_Alarm.InsertString(0, TEXT("OFF"));
	m_CComboBox_ProgramLED_Alarm.InsertString(1, TEXT("ON"));
	m_CComboBox_ProgramLED_Alarm.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab3::OnTimer(UINT_PTR nIDEvent)
{
	if( 1 == nIDEvent )
	{
		KillTimer(1);

		switch( m_nStep )
		{
		case 0:  fnGetGPOStatus();			m_nStep++; break;
		case 1:  fnGetGPIStatus();			m_nStep++; break;
		case 2:  fnGetWakeOnLanStatus();	m_nStep++; break;
		case 3:  fnGetExternal12VStatus();	m_nStep++; break;
		case 4:  fnGetProgramLEDStatus();	m_nStep++; break;
		default: break;
		}

		if( m_nStep < 5 )
			SetTimer(1, 100, NULL);
		else
			SetTimer(2, 100, NULL);
	}

	if( 2 == nIDEvent )
	{
		KillTimer(2);

		if( IsWindowVisible() )
		{
			fnGetGPIStatus();
		}

		SetTimer(2, 500, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}

void CDialogConfigTab3::fnGetGPOStatus()
{
	int nGPO1;
	int nGPO2;
	int nGPO3;
	int nGPO4;
	int nResult = GetGPOStatus(&nGPO1, &nGPO2, &nGPO3, &nGPO4);
	if( nResult == 1 )
	{
		CString strGPO1Status;
		switch(nGPO1)
		{
		case 0: strGPO1Status = TEXT("Low"); break;
		case 1: strGPO1Status = TEXT("High"); break;
		default: strGPO1Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPO1_Status.SetWindowText(strGPO1Status);

		CString strGPO2Status;
		switch(nGPO2)
		{
		case 0: strGPO2Status = TEXT("Low"); break;
		case 1: strGPO2Status = TEXT("High"); break;
		default: strGPO2Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPO2_Status.SetWindowText(strGPO2Status);

		CString strGPO3Status;
		switch(nGPO3)
		{
		case 0: strGPO3Status = TEXT("Low"); break;
		case 1: strGPO3Status = TEXT("High"); break;
		default: strGPO3Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPO3_Status.SetWindowText(strGPO3Status);

		CString strGPO4Status;
		switch(nGPO4)
		{
		case 0: strGPO4Status = TEXT("Low"); break;
		case 1: strGPO4Status = TEXT("High"); break;
		default: strGPO4Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPO4_Status.SetWindowText(strGPO4Status);
	}
	else
	{
		m_CEdit_GPO1_Status.SetWindowText(TEXT("?"));
		m_CEdit_GPO2_Status.SetWindowText(TEXT("?"));
		m_CEdit_GPO3_Status.SetWindowText(TEXT("?"));
		m_CEdit_GPO4_Status.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab3::fnGetGPIStatus()
{
	int nGPI1;
	int nGPI2;
	int nGPI3;
	int nGPI4;
	int nResult = GetGPIStatus(&nGPI1, &nGPI2, &nGPI3, &nGPI4);
	if( nResult == 1 )
	{
		CString strGPI1Status;
		switch(nGPI1)
		{
		case 0: strGPI1Status = TEXT("Low"); break;
		case 1: strGPI1Status = TEXT("High"); break;
		default: strGPI1Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPI1.SetWindowText(strGPI1Status);

		CString strGPI2Status;
		switch(nGPI2)
		{
		case 0: strGPI2Status = TEXT("Low"); break;
		case 1: strGPI2Status = TEXT("High"); break;
		default: strGPI2Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPI2.SetWindowText(strGPI2Status);

		CString strGPI3Status;
		switch(nGPI3)
		{
		case 0: strGPI3Status = TEXT("Low"); break;
		case 1: strGPI3Status = TEXT("High"); break;
		default: strGPI3Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPI3.SetWindowText(strGPI3Status);

		CString strGPI4Status;
		switch(nGPI4)
		{
		case 0: strGPI4Status = TEXT("Low"); break;
		case 1: strGPI4Status = TEXT("High"); break;
		default: strGPI4Status = TEXT("Undefined"); break;
		}
		m_CEdit_GPI4.SetWindowText(strGPI4Status);
	}
	else
	{
		m_CEdit_GPI1.SetWindowText(TEXT("?"));
		m_CEdit_GPI2.SetWindowText(TEXT("?"));
		m_CEdit_GPI3.SetWindowText(TEXT("?"));
		m_CEdit_GPI4.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab3::fnGetWakeOnLanStatus()
{
	int nWakeOnLanStatus = 0;
	int nResult = GetWakeOnLanStatus(&nWakeOnLanStatus);
	if( nResult == 1 )
	{
		CString strWakeOnLanStatus;
		switch(nWakeOnLanStatus)
		{
		case 0: strWakeOnLanStatus = TEXT("Disable"); break;
		case 1: strWakeOnLanStatus = TEXT("Enable"); break;
		default: strWakeOnLanStatus = TEXT("Undefined"); break;
		}
		m_CEdit_WakeOnLan.SetWindowText(strWakeOnLanStatus);
	}
	else
	{
		m_CEdit_WakeOnLan.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab3::fnGetExternal12VStatus()
{
	int nExternal12VStatus = 0;
	int nResult = GetExternal12VStatus(&nExternal12VStatus);
	if( nResult == 1 )
	{
		CString strExternal12VStatus;
		switch(nExternal12VStatus)
		{
		case 0: strExternal12VStatus = TEXT("Disable"); break;
		case 1: strExternal12VStatus = TEXT("Enable"); break;
		default: strExternal12VStatus = TEXT("Undefined"); break;
		}
		m_CEdit_External12V.SetWindowText(strExternal12VStatus);
	}
	else
	{
		m_CEdit_External12V.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab3::fnGetProgramLEDStatus()
{
	int nLED_1 = 0;
	int nLED_2 = 0;
	int nLED_3 = 0;
	int nLED_Alarm = 0;

	int nResult = GetProgramLEDStatus(&nLED_1, &nLED_2, &nLED_3, &nLED_Alarm);
	if( nResult == 1 )
	{
		switch(nLED_1)
		{
		case 0: m_CEdit_ProgramLED1.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_ProgramLED1.SetWindowText(TEXT("Orange")); break;
		case 2: m_CEdit_ProgramLED1.SetWindowText(TEXT("Green")); break;
		default: m_CEdit_ProgramLED1.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nLED_2)
		{
		case 0: m_CEdit_ProgramLED2.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_ProgramLED2.SetWindowText(TEXT("Orange")); break;
		case 2: m_CEdit_ProgramLED2.SetWindowText(TEXT("Green")); break;
		default: m_CEdit_ProgramLED2.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nLED_3)
		{
		case 0: m_CEdit_ProgramLED3.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_ProgramLED3.SetWindowText(TEXT("ON")); break;
		default: m_CEdit_ProgramLED3.SetWindowText(TEXT("Undefined")); break;
		}

		switch(nLED_Alarm)
		{
		case 0: m_CEdit_ProgramLED_Alarm.SetWindowText(TEXT("OFF")); break;
		case 1: m_CEdit_ProgramLED_Alarm.SetWindowText(TEXT("ON")); break;
		default: m_CEdit_ProgramLED_Alarm.SetWindowText(TEXT("Undefined")); break;
		}
	}
	else
	{
		m_CEdit_ProgramLED1.SetWindowText(TEXT("?"));
		m_CEdit_ProgramLED2.SetWindowText(TEXT("?"));
		m_CEdit_ProgramLED3.SetWindowText(TEXT("?"));
		m_CEdit_ProgramLED_Alarm.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab3::OnBnClickedButton1()
{
	int nGPO1 = m_CComboBox_SetGPO1.GetCurSel();
	int nGPO2 = m_CComboBox_SetGPO2.GetCurSel();
	int nGPO3 = m_CComboBox_SetGPO3.GetCurSel();
	int nGPO4 = m_CComboBox_SetGPO4.GetCurSel();
	int nResult = SetGPOControl(nGPO1, nGPO2, nGPO3, nGPO4);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPO success."));

		fnGetGPOStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set GPO failed!!!"));
	}
}

void CDialogConfigTab3::OnBnClickedButton2()
{
	fnGetGPIStatus();
}

void CDialogConfigTab3::OnBnClickedButton3()
{
	int nLED1 = m_CComboBox_ProgramLED1.GetCurSel();
	int nLED2 = m_CComboBox_ProgramLED2.GetCurSel();
	int nLED3 = m_CComboBox_ProgramLED3.GetCurSel();
	int nLED_Alarm = m_CComboBox_ProgramLED_Alarm.GetCurSel();

	int nResult = SetProgramLEDControl(nLED1, nLED2, nLED3, nLED_Alarm);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Program LED Control Success."));

		fnGetProgramLEDStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Program LED Control Failed!!!"));
	}
}

void CDialogConfigTab3::OnBnClickedButton4()
{
	unsigned int nEnable  = m_CComboBox_WakeOnLan.GetCurSel();
	int nResult = SetWakeOnLanControl(nEnable);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Wake On Lan Success."));

		fnGetWakeOnLanStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Wake On Lan Failed!!!"));
	}
}

void CDialogConfigTab3::OnBnClickedButton5()
{
	unsigned int nEnable  = m_CComboBox_External12V.GetCurSel();
	int nResult = SetExternal12VControl(nEnable);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set External 12V Control Success."));

		fnGetExternal12VStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set External 12V Control Failed!!!"));
	}
}

void CDialogConfigTab3::DoCommand()
{
	if( FALSE == m_isDoCommand )
	{
		m_isDoCommand = TRUE;
		m_nStep = 0;
		SetTimer(1, 0, NULL);
	}
}

void CDialogConfigTab3::ResetDoCommand()
{
	m_isDoCommand = FALSE;
}
