// DialogConfigTab1.cpp : @
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "DialogConfigTab1.h"
#include "VTC6221.h"
#include "VTC6221_UtilityDlg.h"


// CDialogConfigTab1 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab1, CDialog)

CDialogConfigTab1::CDialogConfigTab1(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab1::IDD, pParent)
{
	m_isDoCommand = FALSE;
}

CDialogConfigTab1::~CDialogConfigTab1()
{
}

void CDialogConfigTab1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_BIOS_Ver);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_MCUversion);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_Ignition);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_SupplyVoltage);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_PowerType);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_StartupShutdown);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_StartupShutdownOption);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab1, CDialog)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab1::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab1::OnBnClickedButton2)
END_MESSAGE_MAP()


// CDialogConfigTab1 TBz`

BOOL CDialogConfigTab1::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_StartupShutdownOption.ResetContent();
	m_CComboBox_StartupShutdownOption.InsertString(0, TEXT("11.5V / 10.5V       23.0V / 21.0V"));
	m_CComboBox_StartupShutdownOption.InsertString(1, TEXT("12.0V / 11.0V       24.0V / 22.0V"));
	m_CComboBox_StartupShutdownOption.InsertString(2, TEXT("12.5V / 11.0V       25.0V / 22.0V"));
	m_CComboBox_StartupShutdownOption.InsertString(3, TEXT("12.5V / 11.5V       25.0V / 23.0V"));
	m_CComboBox_StartupShutdownOption.SetCurSel(0);

	// BIOS Ver
	TCHAR szBIOS_Ver[32];
	SecureZeroMemory(szBIOS_Ver, sizeof(szBIOS_Ver));

#ifdef  UNICODE
	if( Get_BIOS_Version_W(szBIOS_Ver, sizeof(szBIOS_Ver)/sizeof(TCHAR)) )
#else
	if( Get_BIOS_Version(szBIOS_Ver, sizeof(szBIOS_Ver)) )
#endif
	{
		m_CEdit_BIOS_Ver.SetWindowText(szBIOS_Ver);
	}
	else
	{
		m_CEdit_BIOS_Ver.SetWindowText(TEXT("unknown"));
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab1::OnTimer(UINT_PTR nIDEvent)
{
	if( 1 == nIDEvent )
	{
		KillTimer(1);

		switch( m_nStep )
		{
		case 0:  fnGetMCUVersion();				m_nStep++; break;
		case 1:  fnGetIgnitionStatus();			m_nStep++; break;
		case 2:  fnGetSupplyVoltage();			m_nStep++; break;
		case 3:  fnGetPowerType();				m_nStep++; break;
		case 4:  fnGetStartupShutdownOption();	m_nStep++; break;
		default: break;
		}

		if( m_nStep < 5 )
			SetTimer(1, 100, NULL);
		else
			SetTimer(2, 100, NULL);
	}

	if( 2 == nIDEvent )
	{
		KillTimer(2);

		if( IsWindowVisible() )
		{
			static unsigned int nSystemCount = 0;

			switch(nSystemCount%2)
			{
			case 0: fnGetIgnitionStatus(); break;
			case 1: fnGetSupplyVoltage(); break;
			}

			nSystemCount++;
		}

		SetTimer(2, 200, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}

void CDialogConfigTab1::fnGetMCUVersion()
{
	int nMCUVersion = 0;
	int nResult = GetMCUVersion(&nMCUVersion);
	if( nResult == 1 )
	{
		CString strMCUVersion;
		strMCUVersion.Format(TEXT("VT640R%02d"), nMCUVersion);
		m_CEdit_MCUversion.SetWindowText(strMCUVersion);
	}
	else
	{
		m_CEdit_MCUversion.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab1::fnGetIgnitionStatus()
{
	int nIgnitionStatus = 0;
	int nResult = GetIgnitionStatus(&nIgnitionStatus);
	if( nResult == 1 )
	{
		CString strIgnition;
		switch(nIgnitionStatus)
		{
		case 0: strIgnition = TEXT("OFF"); break;
		case 1: strIgnition = TEXT("ON"); break;
		default: strIgnition = TEXT("Undefined"); break;
		}
		m_CEdit_Ignition.SetWindowText(strIgnition);
	}
	else
	{
		m_CEdit_Ignition.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab1::fnGetSupplyVoltage()
{
	int nSupplyVoltage = 0;
	int nResult = GetSupplyVoltage(&nSupplyVoltage);
	if( nResult == 1 )
	{
		double fVoltage = (double)nSupplyVoltage/1000;
		CString strSupplyVoltage;
		strSupplyVoltage.Format(TEXT("%2.1f V"), fVoltage); 
		m_CEdit_SupplyVoltage.SetWindowText(strSupplyVoltage);
	}
	else
	{
		m_CEdit_SupplyVoltage.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab1::fnGetPowerType()
{
	int nPowerType = 0;
	int nResult = GetPowerType(&nPowerType);
	if( nResult == 1 )
	{
		CString strPowerType;
		switch(nPowerType)
		{
		case 0: strPowerType = TEXT("9~48V"); break;
		case 1: strPowerType = TEXT("Reserved(9~48V)"); break;
		case 2: strPowerType = TEXT("24V"); break;
		case 3: strPowerType = TEXT("12V"); break;
		default: strPowerType = TEXT("Undefined"); break;
		}
		m_CEdit_PowerType.SetWindowText(strPowerType);
	}
	else
	{
		m_CEdit_PowerType.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab1::fnGetStartupShutdownOption()
{
	int nStartupShutdownOption = 0;
	int nResult = GetStartupShutdownOption(&nStartupShutdownOption);
	if( nResult == 1 )
	{
		CString StartupShutdownOption;
		switch(nStartupShutdownOption)
		{
		case 0: StartupShutdownOption = TEXT("11.5V / 10.5V       23.0V / 21.0V"); break;
		case 1: StartupShutdownOption = TEXT("12.0V / 11.0V       24.0V / 22.0V"); break;
		case 2: StartupShutdownOption = TEXT("12.5V / 11.0V       25.0V / 22.0V"); break;
		case 3: StartupShutdownOption = TEXT("12.5V / 11.5V       25.0V / 23.0V"); break;
		default: StartupShutdownOption = TEXT("Undefined"); break;
		}
		m_CEdit_StartupShutdown.SetWindowText(StartupShutdownOption);
	}
	else
	{
		m_CEdit_StartupShutdown.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab1::OnBnClickedButton1()
{
	fnGetPowerType();
}

void CDialogConfigTab1::OnBnClickedButton2()
{
	int nOption = m_CComboBox_StartupShutdownOption.GetCurSel();
	int nResult = SetStartupShutdownOption(nOption);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Startup Shutdown Option Success."));

		fnGetStartupShutdownOption();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Startup Shutdown Option Failed!!!"));
	}
}

void CDialogConfigTab1::DoCommand()
{
	if( FALSE == m_isDoCommand )
	{
		m_isDoCommand = TRUE;
		m_nStep = 0;
		SetTimer(1, 0, NULL);
	}
}

void CDialogConfigTab1::ResetDoCommand()
{
	m_isDoCommand = FALSE;
}
