
// VTC6221_UtilityDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "VTC6221_UtilityDlg.h"
#include "VTC6221.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CVTC6221_UtilityDlg dialog




CVTC6221_UtilityDlg::CVTC6221_UtilityDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVTC6221_UtilityDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVTC6221_UtilityDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB1, m_CTabCtrl_Config);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_Message);
}

BEGIN_MESSAGE_MAP(CVTC6221_UtilityDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DESTROY()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, &CVTC6221_UtilityDlg::OnTcnSelchangeTab1)
	ON_BN_CLICKED(IDC_BUTTON1, &CVTC6221_UtilityDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CVTC6221_UtilityDlg::OnBnClickedButton2)
END_MESSAGE_MAP()


// CVTC6221_UtilityDlg message handlers

BOOL CVTC6221_UtilityDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	m_CTabCtrl_Config.InsertItem(0, TEXT("System 1"));
	m_CTabCtrl_Config.InsertItem(1, TEXT("System 2"));
	m_CTabCtrl_Config.InsertItem(2, TEXT("I/O"));
	m_CTabCtrl_Config.InsertItem(3, TEXT("Module"));
	m_CTabCtrl_Config.InsertItem(4, TEXT("G-Sensor"));
	m_CTabCtrl_Config.InsertItem(5, TEXT("Event"));
	m_CTabCtrl_Config.SetCurSel(0);

	RECT Rect;
	m_CTabCtrl_Config.GetItemRect(0, &Rect);
	CSize cSize;
	cSize.cx = Rect.right - Rect.left;
	cSize.cy = Rect.bottom - Rect.top + 20;
	m_CTabCtrl_Config.SetItemSize(cSize);

	CRect rc;
	m_CTabCtrl_Config.GetClientRect(rc);
	rc.top += 21 + 20;
	rc.bottom -= 1;
	rc.left += 1;
	rc.right -= 1;

	m_TabDialog1.Create(IDD_DIALOG1, &m_CTabCtrl_Config);
	m_TabDialog2.Create(IDD_DIALOG2, &m_CTabCtrl_Config);
	m_TabDialog3.Create(IDD_DIALOG3, &m_CTabCtrl_Config);
	m_TabDialog4.Create(IDD_DIALOG4, &m_CTabCtrl_Config);
	m_TabDialog5.Create(IDD_DIALOG5, &m_CTabCtrl_Config);
	m_TabDialog6.Create(IDD_DIALOG6, &m_CTabCtrl_Config);

	m_TabDialog1.MoveWindow(&rc);
	m_TabDialog2.MoveWindow(&rc);
	m_TabDialog3.MoveWindow(&rc);
	m_TabDialog4.MoveWindow(&rc);
	m_TabDialog5.MoveWindow(&rc);
	m_TabDialog6.MoveWindow(&rc);

	m_TabDialog1.ShowWindow(SW_SHOW);
	m_TabDialog2.ShowWindow(SW_HIDE);
	m_TabDialog3.ShowWindow(SW_HIDE);
	m_TabDialog4.ShowWindow(SW_HIDE);
	m_TabDialog5.ShowWindow(SW_HIDE);
	m_TabDialog6.ShowWindow(SW_HIDE);

#ifdef _DEBUG
	m_CEdit_Message.ShowWindow(SW_SHOW);
#else
	m_CEdit_Message.ShowWindow(SW_HIDE);
#endif

	int nMajorVersion = 0;
	int nMinorVersion = 0;
	Get_DLL_Version(&nMajorVersion, &nMinorVersion);
	CString DLLVersion;
	DLLVersion.Format(TEXT("DLL ver : %d.%d"), nMajorVersion, nMinorVersion);
	m_CEdit_Message.SetWindowText(DLLVersion);

	int nResult = Connect();
	if( nResult != 1 )
	{
		MessageBox(TEXT("Connect to device failed!!!"), 0, MB_ICONWARNING );
	}
	else
	{
		CString strHWVersion;
		int nHWVersion = 0;
		nResult = GetHWVersion(&nHWVersion);
		if( nResult == 1 )
		{
			strHWVersion.Format(TEXT("PCB : %c"), 65+nHWVersion);
		}
		else
		{
			strHWVersion.Format(TEXT("PCB : ?"));
		}

		CString strDTPVersion;
		int nDTPVersion = 0;
		nResult = GetDTPVersion(&nDTPVersion);
		if( nResult == 1 )
		{
			strDTPVersion.Format(TEXT("MCU DTP : %d"), nDTPVersion);
		}
		else
		{
			strDTPVersion.Format(TEXT("MCU DTP : ?"));
		}

		CString strBLVersion;
		int nBLVersion = 0;
		nResult = GetBLVersion(&nBLVersion);
		if( nResult == 1 )
		{
			strBLVersion.Format(TEXT("MCU BL : %d"), nBLVersion);
		}
		else
		{
			strBLVersion.Format(TEXT("MCU BL : ?"));
		}

		CString strOtherVersion;
		strOtherVersion = DLLVersion + TEXT(", ") + strHWVersion + TEXT(", ") + strDTPVersion + TEXT(", ") + strBLVersion;
		m_CEdit_Message.SetWindowText(strOtherVersion);
	}

	m_TabDialog1.DoCommand();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVTC6221_UtilityDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVTC6221_UtilityDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVTC6221_UtilityDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CVTC6221_UtilityDlg::OnDestroy()
{
	CDialog::OnDestroy();

	Disconnect();
}

void CVTC6221_UtilityDlg::OnTcnSelchangeTab1(NMHDR *pNMHDR, LRESULT *pResult)
{
	m_CEdit_Message.SetWindowText(TEXT(""));

	m_TabDialog1.ShowWindow(SW_HIDE);
	m_TabDialog2.ShowWindow(SW_HIDE);
	m_TabDialog3.ShowWindow(SW_HIDE);
	m_TabDialog4.ShowWindow(SW_HIDE);
	m_TabDialog5.ShowWindow(SW_HIDE);
	m_TabDialog6.ShowWindow(SW_HIDE);

	int nCurSel = m_CTabCtrl_Config.GetCurSel();
	switch(nCurSel)
	{
	case 0:
		m_TabDialog1.ShowWindow(SW_SHOW);
		m_TabDialog1.DoCommand();
		break;
	case 1:
		m_TabDialog2.ShowWindow(SW_SHOW);
		m_TabDialog2.DoCommand();
		break;
	case 2:
		m_TabDialog3.ShowWindow(SW_SHOW);
		m_TabDialog3.DoCommand();
		break;
	case 3:
		m_TabDialog4.ShowWindow(SW_SHOW);
		m_TabDialog4.DoCommand();
		break;
	case 4:
		m_TabDialog5.ShowWindow(SW_SHOW);
		m_TabDialog5.DoCommand();
		break;
	case 5:
		m_TabDialog6.ShowWindow(SW_SHOW);
		break;
	default:
		m_CTabCtrl_Config.SetCurSel(0);
		m_TabDialog1.ShowWindow(SW_SHOW);
		m_TabDialog1.DoCommand();
		break;
	}

	*pResult = 0;
}

void CVTC6221_UtilityDlg::OnBnClickedButton1()
{
	int nResult = SetLoadDefault();
	if( nResult == 1 )
	{
		m_CEdit_Message.SetWindowText(TEXT("Load Default Success."));
		MessageBox(TEXT("Loading factory default settings successfully."));

		m_TabDialog1.ResetDoCommand();
		m_TabDialog2.ResetDoCommand();
		m_TabDialog3.ResetDoCommand();
		m_TabDialog4.ResetDoCommand();

		int nSel = m_CTabCtrl_Config.GetCurSel();
		switch(nSel)
		{
		case 0: // System 1
			m_TabDialog1.DoCommand();
			break;
		case 1: // System 2
			m_TabDialog2.DoCommand();
			break;
		case 2: // I/O
			m_TabDialog3.DoCommand();
			break;
		case 3: // Module
			m_TabDialog4.DoCommand();
			break;
		}
	}
	else
	{
		m_CEdit_Message.SetWindowText(TEXT("Load Default Failed!!!"));
		MessageBox(TEXT("Loading factory default settings failed!!!"), 0, MB_ICONWARNING );
	}
}

void CVTC6221_UtilityDlg::OnBnClickedButton2()
{
	int nResult = SetFlashUpdate();
	if( nResult == 1 )
	{
		m_CEdit_Message.SetWindowText(TEXT("Update Flash Success."));

		CString strMessage;
		strMessage = "The following settings have been saved :\n\n"
			         "1. Startup/Shutdown voltage\n"
					 "2. Power On/Off Delay Timer\n"
					 "3. WWAN\n"
					 "4. Wake On LAN\n"
					 "5. RTC Wake Up Timer";
		MessageBox(strMessage);
	}
	else
	{
		m_CEdit_Message.SetWindowText(TEXT("Update Flash Failed!!!"));
		MessageBox(TEXT("Failed to save settings!!!"), 0, MB_ICONWARNING );
	}
}
