// DialogConfigTab6.cpp : @
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "DialogConfigTab6.h"
#include "VTC6221.h"


CDialogConfigTab6 *g_pCDialogConfigTab6 = NULL;

void __stdcall EventSystemAlarm(unsigned char byAlarm)
{
	if( byAlarm & 0x01 )
		g_pCDialogConfigTab6->AddEventMessage(TEXT("Over voltage"));

	if( byAlarm & 0x02 )
		g_pCDialogConfigTab6->AddEventMessage(TEXT("Lower voltage"));

	if( byAlarm & 0x04 )
		g_pCDialogConfigTab6->AddEventMessage(TEXT("Over temperature"));

	if( byAlarm & 0x08 )
		g_pCDialogConfigTab6->AddEventMessage(TEXT("Lower temperature"));
}


// CDialogConfigTab6 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab6, CDialog)

CDialogConfigTab6::CDialogConfigTab6(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab6::IDD, pParent)
{

}

CDialogConfigTab6::~CDialogConfigTab6()
{
}

void CDialogConfigTab6::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST1, m_CListBox_Event);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab6, CDialog)
END_MESSAGE_MAP()


// CDialogConfigTab6 TBz`

BOOL CDialogConfigTab6::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	g_pCDialogConfigTab6 = this;

	RegisterSystemAlarmCallBackFunction(EventSystemAlarm);

	m_CListBox_Event.ModifyStyle(LBS_SORT, 0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab6::AddEventMessage(CString strMessage)
{
	SYSTEMTIME systemTime;
	GetLocalTime(&systemTime);

	CString strData;
	strData.Format(TEXT("%04d/%02d/%02d %02d:%02d:%02d:%03d ==> %s"), systemTime.wYear, systemTime.wMonth, systemTime.wDay, systemTime.wHour, systemTime.wMinute, systemTime.wSecond, systemTime.wMilliseconds, strMessage);

	while ( m_CListBox_Event.GetCount() >= 100 )
	{
		m_CListBox_Event.DeleteString(0);
	}

	int nCount = m_CListBox_Event.GetCount();
	m_CListBox_Event.InsertString(nCount, strData);
	m_CListBox_Event.SetCaretIndex(nCount);
}
