// DialogConfigTab2.cpp : @
//

#include "stdafx.h"
#include "VTC6221_Utility.h"
#include "DialogConfigTab2.h"
#include "VTC6221.h"
#include "VTC6221_UtilityDlg.h"


// CDialogConfigTab2 ܤ

IMPLEMENT_DYNAMIC(CDialogConfigTab2, CDialog)

CDialogConfigTab2::CDialogConfigTab2(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogConfigTab2::IDD, pParent)
{
	m_isDoCommand = FALSE;
}

CDialogConfigTab2::~CDialogConfigTab2()
{
}

void CDialogConfigTab2::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, m_CEdit_DelayTime_DelayOffEnable);
	DDX_Control(pDX, IDC_COMBO1, m_CComboBox_PowerOffDelayTime_Enable);
	DDX_Control(pDX, IDC_EDIT2, m_CEdit_DelayTime_DelayOnEnable);
	DDX_Control(pDX, IDC_COMBO2, m_CComboBox_PowerOnDelayTime_Enable);
	DDX_Control(pDX, IDC_EDIT3, m_CEdit_DelayTime_PowerOff);
	DDX_Control(pDX, IDC_COMBO3, m_CComboBox_PowerOffDelayTime);
	DDX_Control(pDX, IDC_EDIT4, m_CEdit_DelayTime_PowerOn);
	DDX_Control(pDX, IDC_COMBO4, m_CComboBox_PowerOnDelayTime);
	DDX_Control(pDX, IDC_EDIT5, m_CEdit_RTC_Status);
	DDX_Control(pDX, IDC_COMBO5, m_CComboBox_RTC_Enable);
	DDX_Control(pDX, IDC_EDIT6, m_CEdit_AlarmTimerHour);
	DDX_Control(pDX, IDC_COMBO6, m_CComboBox_AlarmTimer_Hour);
	DDX_Control(pDX, IDC_EDIT7, m_CEdit_AlarmTimerMin);
	DDX_Control(pDX, IDC_COMBO7, m_CComboBox_AlarmTimer_Min);
	DDX_Control(pDX, IDC_EDIT8, m_CEdit_AlarmTimerSec);
	DDX_Control(pDX, IDC_COMBO8, m_CComboBox_AlarmTimer_Sec);
	DDX_Control(pDX, IDC_EDIT9, m_CEdit_WDT_Enable);
	DDX_Control(pDX, IDC_COMBO9, m_CComboBox_WDT_Enable);
	DDX_Control(pDX, IDC_EDIT10, m_CEdit_WDT_TimeInterval);
	DDX_Control(pDX, IDC_COMBO10, m_CComboBox_WDT_TimeInterval);
}


BEGIN_MESSAGE_MAP(CDialogConfigTab2, CDialog)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, &CDialogConfigTab2::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CDialogConfigTab2::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CDialogConfigTab2::OnBnClickedButton3)
	ON_BN_CLICKED(IDC_BUTTON4, &CDialogConfigTab2::OnBnClickedButton4)
	ON_BN_CLICKED(IDC_BUTTON5, &CDialogConfigTab2::OnBnClickedButton5)
END_MESSAGE_MAP()


// CDialogConfigTab2 TBz`

BOOL CDialogConfigTab2::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO: Add extra initialization here

	m_CComboBox_PowerOffDelayTime_Enable.ResetContent();
	m_CComboBox_PowerOffDelayTime_Enable.InsertString(0, TEXT("Disable"));
	m_CComboBox_PowerOffDelayTime_Enable.InsertString(1, TEXT("Enable"));
	m_CComboBox_PowerOffDelayTime_Enable.SetCurSel(0);

	m_CComboBox_PowerOffDelayTime.ResetContent();
	m_CComboBox_PowerOffDelayTime.InsertString(0, TEXT("20 Sec"));
	m_CComboBox_PowerOffDelayTime.InsertString(1, TEXT("1 Min"));
	m_CComboBox_PowerOffDelayTime.InsertString(2, TEXT("5 Mins"));
	m_CComboBox_PowerOffDelayTime.InsertString(3, TEXT("10 Mins"));
	m_CComboBox_PowerOffDelayTime.InsertString(4, TEXT("30 Mins"));
	m_CComboBox_PowerOffDelayTime.InsertString(5, TEXT("1 Hour"));
	m_CComboBox_PowerOffDelayTime.InsertString(6, TEXT("6 Hours"));
	m_CComboBox_PowerOffDelayTime.InsertString(7, TEXT("18 Hours"));
	m_CComboBox_PowerOffDelayTime.SetCurSel(0);

	m_CComboBox_PowerOnDelayTime_Enable.ResetContent();
	m_CComboBox_PowerOnDelayTime_Enable.InsertString(0, TEXT("Disable"));
	m_CComboBox_PowerOnDelayTime_Enable.InsertString(1, TEXT("Enable"));
	m_CComboBox_PowerOnDelayTime_Enable.SetCurSel(0);

	m_CComboBox_PowerOnDelayTime.ResetContent();
	m_CComboBox_PowerOnDelayTime.InsertString(0, TEXT("10 Sec"));
	m_CComboBox_PowerOnDelayTime.InsertString(1, TEXT("30 Sec"));
	m_CComboBox_PowerOnDelayTime.InsertString(2, TEXT("1Min"));
	m_CComboBox_PowerOnDelayTime.InsertString(3, TEXT("5 Mins"));
	m_CComboBox_PowerOnDelayTime.InsertString(4, TEXT("10 Mins"));
	m_CComboBox_PowerOnDelayTime.InsertString(5, TEXT("15 Mins"));
	m_CComboBox_PowerOnDelayTime.InsertString(6, TEXT("30 Mins"));
	m_CComboBox_PowerOnDelayTime.InsertString(7, TEXT("1 Hour"));
	m_CComboBox_PowerOnDelayTime.SetCurSel(0);

	m_CComboBox_RTC_Enable.ResetContent();
	m_CComboBox_RTC_Enable.InsertString(0, TEXT("Disable"));
	m_CComboBox_RTC_Enable.InsertString(1, TEXT("Enable"));
	m_CComboBox_RTC_Enable.SetCurSel(0);

	m_CComboBox_AlarmTimer_Hour.ResetContent();
	for ( int i=0 ; i<=23 ; i++ )
	{
		CString strAlarmTimer_Hour;
		strAlarmTimer_Hour.Format(TEXT("%0d"), i);
		m_CComboBox_AlarmTimer_Hour.InsertString(i, strAlarmTimer_Hour);
	}
	m_CComboBox_AlarmTimer_Hour.SetCurSel(0);

	m_CComboBox_AlarmTimer_Min.ResetContent();
	for ( int i=0 ; i<=59 ; i++ )
	{
		CString strAlarmTimer_Min;
		strAlarmTimer_Min.Format(TEXT("%0d"), i);
		m_CComboBox_AlarmTimer_Min.InsertString(i, strAlarmTimer_Min);
	}
	m_CComboBox_AlarmTimer_Min.SetCurSel(0);

	m_CComboBox_AlarmTimer_Sec.ResetContent();
	for ( int i=0 ; i<=59 ; i++ )
	{
		CString strAlarmTimer_Sec;
		strAlarmTimer_Sec.Format(TEXT("%0d"), i);
		m_CComboBox_AlarmTimer_Sec.InsertString(i, strAlarmTimer_Sec);
	}
	m_CComboBox_AlarmTimer_Sec.SetCurSel(0);

	m_CComboBox_WDT_Enable.ResetContent();
	m_CComboBox_WDT_Enable.InsertString(0, TEXT("Disable"));
	m_CComboBox_WDT_Enable.InsertString(1, TEXT("Enable"));
	m_CComboBox_WDT_Enable.SetCurSel(0);

	m_CComboBox_WDT_TimeInterval.ResetContent();
	for ( int i=3 ; i<=255 ; i++ )
	{
		CString strWDT_Timeout;
		strWDT_Timeout.Format(TEXT("%0d"), i);
		m_CComboBox_WDT_TimeInterval.InsertString(i-3, strWDT_Timeout);
	}
	m_CComboBox_WDT_TimeInterval.SetCurSel(0);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDialogConfigTab2::OnTimer(UINT_PTR nIDEvent)
{
	if( 1 == nIDEvent )
	{
		KillTimer(1);

		switch( m_nStep )
		{
		case 0: fnGetDelayTimeOption();	m_nStep++; break;
		case 1: fnGetRTCStatus();		m_nStep++; break;
		case 2: fnGetAlarmTimer();		m_nStep++; break;
		case 3: fnGetWatchdogConfig();	m_nStep++; break;
		default: break;
		}

		if( m_nStep < 4 )
			SetTimer(1, 50, NULL);
	}

	CDialog::OnTimer(nIDEvent);
}

void CDialogConfigTab2::fnGetDelayTimeOption()
{
	int nPowerOff = 0;
	int nPowerOn = 0;
	int nDelayOffEnable = 0;
	int nDelayOnEnable = 0;

	int nResult = GetDelayTimeOption(&nPowerOff, &nPowerOn, &nDelayOffEnable, &nDelayOnEnable);
	if( nResult == 1 )
	{
		CString strPowerOff;
		switch(nPowerOff)
		{
		case 0: strPowerOff = TEXT("20 sec"); break;
		case 1: strPowerOff = TEXT("1 Min"); break;
		case 2: strPowerOff = TEXT("5 Mins"); break;
		case 3: strPowerOff = TEXT("10 Mins"); break;
		case 4: strPowerOff = TEXT("30 Mins"); break;
		case 5: strPowerOff = TEXT("1 Hour"); break;
		case 6: strPowerOff = TEXT("6 Hours"); break;
		case 7: strPowerOff = TEXT("18 Hours"); break;
		default: strPowerOff = TEXT("Undefined"); break;
		}
		m_CEdit_DelayTime_PowerOff.SetWindowText(strPowerOff);

		CString strPowerOn;
		switch(nPowerOn)
		{
		case 0: strPowerOn = TEXT("10 sec"); break;
		case 1: strPowerOn = TEXT("30 sec"); break;
		case 2: strPowerOn = TEXT("1 Min"); break;
		case 3: strPowerOn = TEXT("5 Mins"); break;
		case 4: strPowerOn = TEXT("10 Mins"); break;
		case 5: strPowerOn = TEXT("15 Mins"); break;
		case 6: strPowerOn = TEXT("30 Mins"); break;
		case 7: strPowerOn = TEXT("1 Hour"); break;
		default: strPowerOn = TEXT("Undefined"); break;
		}
		m_CEdit_DelayTime_PowerOn.SetWindowText(strPowerOn);

		CString strDelayOffEnable;
		switch(nDelayOffEnable)
		{
		case 0: strDelayOffEnable = TEXT("Disable"); break;
		case 1: strDelayOffEnable = TEXT("Enable"); break;
		default: strDelayOffEnable = TEXT("Undefined"); break;
		}
		m_CEdit_DelayTime_DelayOffEnable.SetWindowText(strDelayOffEnable);

		CString strDelayOnEnable;
		switch(nDelayOnEnable)
		{
		case 0: strDelayOnEnable = TEXT("Disable"); break;
		case 1: strDelayOnEnable = TEXT("Enable"); break;
		default: strDelayOnEnable = TEXT("Undefined"); break;
		}
		m_CEdit_DelayTime_DelayOnEnable.SetWindowText(strDelayOnEnable);
	}
	else
	{
		m_CEdit_DelayTime_PowerOff.SetWindowText(TEXT("?"));
		m_CEdit_DelayTime_PowerOn.SetWindowText(TEXT("?"));
		m_CEdit_DelayTime_DelayOffEnable.SetWindowText(TEXT("?"));
		m_CEdit_DelayTime_DelayOnEnable.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab2::fnGetRTCStatus()
{
	int nRTCStatus;
	int nResult = GetRTCStatus(&nRTCStatus);
	if( nResult == 1 )
	{
		CString strRTCStatus;
		switch(nRTCStatus)
		{
		case 0: strRTCStatus = TEXT("Disable"); break;
		case 1: strRTCStatus = TEXT("Enable"); break;
		default: strRTCStatus = TEXT("Undefined"); break;
		}
		m_CEdit_RTC_Status.SetWindowText(strRTCStatus);
	}
	else
	{
		m_CEdit_RTC_Status.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab2::fnGetAlarmTimer()
{
	int nHour;
	int nMin;
	int nSec;
	int nResult = GetAlarmTimer(&nHour, &nMin, &nSec);
	if( nResult == 1 )
	{
		CString strAlarmTimerHour;
		CString strAlarmTimerMin;
		CString strAlarmTimerSec;

		strAlarmTimerHour.Format(TEXT("%d"), nHour);
		strAlarmTimerMin.Format(TEXT("%d"), nMin);
		strAlarmTimerSec.Format(TEXT("%d"), nSec);

		m_CEdit_AlarmTimerHour.SetWindowText(strAlarmTimerHour);
		m_CEdit_AlarmTimerMin.SetWindowText(strAlarmTimerMin);
		m_CEdit_AlarmTimerSec.SetWindowText(strAlarmTimerSec);
	}
	else
	{
		m_CEdit_AlarmTimerHour.SetWindowText(TEXT("?"));
		m_CEdit_AlarmTimerMin.SetWindowText(TEXT("?"));
		m_CEdit_AlarmTimerSec.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab2::fnGetWatchdogConfig()
{
	int nWDT_Enable;
	int nTimeInterval;
	int nResult = GetWatchdogConfig(&nWDT_Enable, &nTimeInterval);
	if( nResult == 1 )
	{
		CString strWDT_Enable;
		switch(nWDT_Enable)
		{
		case 0: strWDT_Enable = TEXT("Disable"); break;
		case 1: strWDT_Enable = TEXT("Enable"); break;
		default: strWDT_Enable = TEXT("Undefined"); break;
		}
		m_CEdit_WDT_Enable.SetWindowText(strWDT_Enable);

		CString strTimeInterval;
		strTimeInterval.Format(TEXT("%d Sec"), nTimeInterval);
		m_CEdit_WDT_TimeInterval.SetWindowText(strTimeInterval);
	}
	else
	{
		m_CEdit_WDT_Enable.SetWindowText(TEXT("?"));
		m_CEdit_WDT_TimeInterval.SetWindowText(TEXT("?"));
	}
}

void CDialogConfigTab2::OnBnClickedButton1()
{
	int nPowerOffDelayTime         = m_CComboBox_PowerOffDelayTime.GetCurSel();
	int nPowerOffDelayTime_Enable  = m_CComboBox_PowerOffDelayTime_Enable.GetCurSel();
	int nPowerOnDelayTime          = m_CComboBox_PowerOnDelayTime.GetCurSel();
	int nPowerOnDelayTime_Enable   = m_CComboBox_PowerOnDelayTime_Enable.GetCurSel();
	int nResult = SetDelayTimeOption(nPowerOffDelayTime, nPowerOffDelayTime_Enable, nPowerOnDelayTime, nPowerOnDelayTime_Enable);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Delay Time Option Success."));

		fnGetDelayTimeOption();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Delay Time Option Failed!!!"));
	}
}

void CDialogConfigTab2::OnBnClickedButton2()
{
	int nEnable = m_CComboBox_RTC_Enable.GetCurSel();
	int nResult = SetRTCControl(nEnable);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set RTC Control Success."));

		fnGetRTCStatus();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set RTC Control Failed!!!"));
	}
}

void CDialogConfigTab2::OnBnClickedButton3()
{
	SYSTEMTIME sysTime;
	GetLocalTime(&sysTime);

	int nResult = SetRTCTimer(sysTime.wHour, sysTime.wMinute, sysTime.wSecond);
	if( nResult == 1 )
	{
		int nHour = m_CComboBox_AlarmTimer_Hour.GetCurSel();
		int nMin  = m_CComboBox_AlarmTimer_Min.GetCurSel();
		int nSec  = m_CComboBox_AlarmTimer_Sec.GetCurSel();
		int nResult = SetAlarmTimer(nHour, nMin, nSec);
		if( nResult == 1 )
		{
			CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
			if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Alarm Timer Success."));

			fnGetAlarmTimer();
		}
		else
		{
			CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
			if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Alarm Timer Failed!!!"));
		}
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set RTC Timer Failed!!!"));
	}
}

void CDialogConfigTab2::OnBnClickedButton4()
{
	int nWDT_Enable = m_CComboBox_WDT_Enable.GetCurSel();
	int nResult = SetWatchdogControl(nWDT_Enable);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Watchdog Control success."));

		fnGetWatchdogConfig();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Watchdog Control failed!!!"));
	}
}

void CDialogConfigTab2::OnBnClickedButton5()
{
	int nTimeInterval = m_CComboBox_WDT_TimeInterval.GetCurSel() + 3;
	int nResult = SetWatchdogTimer(nTimeInterval);
	if( nResult == 1 )
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Watchdog Timer success."));

		fnGetWatchdogConfig();
	}
	else
	{
		CVTC6221_UtilityDlg* p_MainDlg = (CVTC6221_UtilityDlg *)AfxGetMainWnd();
		if( p_MainDlg ) p_MainDlg->m_CEdit_Message.SetWindowText(TEXT("Set Watchdog Timer failed!!!"));
	}
}

void CDialogConfigTab2::DoCommand()
{
	if( FALSE == m_isDoCommand )
	{
		m_isDoCommand = TRUE;
		m_nStep = 0;
		SetTimer(1, 0, NULL);
	}
}

void CDialogConfigTab2::ResetDoCommand()
{
	m_isDoCommand = FALSE;
}
