// VTC6221 API V1.0 2019/10/16
#define VTC6221_API extern "C" __declspec(dllimport)

VTC6221_API void Get_DLL_Version(int *pnMajorVersion, int *pnMinorVersion);
VTC6221_API bool Get_BIOS_Version(char *szBIOS_Ver, int nLen);
VTC6221_API bool Get_BIOS_Version_W(wchar_t *szBIOS_Ver, int nLen);

VTC6221_API int  Connect();
VTC6221_API void Disconnect();

// System command
VTC6221_API int  GetMCUVersion(int *pnMCUVersion);
VTC6221_API int  GetHWVersion(int *pnHWVersion);
VTC6221_API int  GetDTPVersion(int *pnDTPVersion);
VTC6221_API int  GetBLVersion(int *pnBLVersion);
VTC6221_API int  GetIgnitionStatus(int *pnIgnitionStatus);
VTC6221_API int  GetSupplyVoltage(int *pnSupplyVoltage);
VTC6221_API int  GetPowerType(int *pnPowerType);
VTC6221_API int  GetDelayTimeOption(int *pnPowerOff, int *pnPowerOn, int *pnDelayOffEnable, int *pnDelayOnEnable);
VTC6221_API int  GetStartupShutdownOption(int *pnStartupShutdownOption);
VTC6221_API int  GetAlarmTimer(int *pnHour, int *pnMin, int *pnSec);
VTC6221_API int  GetWWANStatus(int *pnWWAN_Enable, int *pnWWAN_Enable2, int *pnWWAN_Enable3, int *pnWWAN_Wakeup_Enable3, int *pnWWAN_Enable4);
VTC6221_API int  GetWiFiStatus(int *pnWiFi_En1, int *pnWiFi_En2, int *pnWiFi_En3, int *pnWiFi_Pw1, int *pnWiFi_Pw2, int *pnWiFi_Pw3);
VTC6221_API int  GetBTStatus(int *pnBTStatus1, int *pnBTStatus2, int *pnBTStatus3);
VTC6221_API int  GetGPSStatus(int *pnGPSStatus);
VTC6221_API int  GetUSBStatus(int *pnUSB2_1, int *pnUSB2_2, int *pnUSB3, int *pnUSB_RES);
VTC6221_API int  GetRTCStatus(int *pnRTCStatus);
VTC6221_API int  GetWatchdogConfig(int *pnWDT_Enable, int *pnTimeInterval);
VTC6221_API int  GetGsensorData(int nRegisterIndex, unsigned char *pbyGsensorData, int nGsensorDataLen);
VTC6221_API int  GetSIMCardStatus(int *pnSIMCard1, int *pnSIMCard2, int *pnSIMCard3, int *pnSIMCard4);
VTC6221_API int  GetGPOStatus(int *pnGPO1, int *pnGPO2, int *pnGPO3, int *pnGPO4);
VTC6221_API int  GetGPIStatus(int *pnGPI1, int *pnGPI2, int *pnGPI3, int *pnGPI4);
VTC6221_API int  GetProgramLEDStatus(int *pnLED_1, int *pnLED_2, int *pnLED_3, int *pnLED_Alarm);
VTC6221_API int  GetWakeOnLanStatus(int *pnWakeOnLanStatus);
VTC6221_API int  GetExternal12VStatus(int *pnExternal12VStatus);
VTC6221_API int  GetPCIESlotMode(int *pnCN5, int *pnCN23);

VTC6221_API int  SetLoadDefault();
VTC6221_API int  SetRTCTimer(int nHour, int nMin, int nSec);
VTC6221_API int  SetDelayTimeOption(int nPowerOffDelayTime, int nPowerOffDelayTime_Enable, int nPowerOnDelayTime, int nPowerOnDelayTime_Enable);
VTC6221_API int  SetStartupShutdownOption(int nOption);
VTC6221_API int  SetAlarmTimer(int nHour, int nMin, int nSec);
VTC6221_API int  SetWWANControl(int nWWAN_Enable, int nWWAN_Enable2, int nWWAN_Enable3, int nWWAN_Wakeup_Enable3, int nWWAN_Enable4);
VTC6221_API int  SetWiFiControl(int nWiFi_En1, int nWiFi_En2, int nWiFi_En3, int nWiFi_Pw1, int nWiFi_Pw2, int nWiFi_Pw3);
VTC6221_API int  SetBTControl(int nBT1, int nBT2, int nBT3);
VTC6221_API int  SetGPSControl(int nEnable);
VTC6221_API int  SetUSBControl(int nUSB2_1, int nUSB2_2, int nUSB3, int nUSB_RES);
VTC6221_API int  SetRTCControl(int nEnable);
VTC6221_API int  SetWatchdogControl(int nWDT_Enable);
VTC6221_API int  SetWatchdogTimer(int nTimeInterval);
VTC6221_API int  SetFlashUpdate();
VTC6221_API int  SetGsensorData(int nRegIdx, unsigned char *pbyData, int nLen);
VTC6221_API int  SetSIMCardSelect(int nSIMCardSelect1, int nSIMCardSelect2, int nSIMCardSelect3, int nSIMCardSelect4);
VTC6221_API int  SetGPOControl(int nGPO1, int nGPO2, int nGPO3, int nGPO4);
VTC6221_API int  SetProgramLEDControl(int nLED1, int nLED2, int nLED3, int nLED_Alarm);
VTC6221_API int  SetWakeOnLanControl(int nEnable);
VTC6221_API int  SetExternal12VControl(int nEnable);

// ================================================================================================================================================
// Call back function
typedef void (__stdcall * EventSystemAlarm_CallBack)(unsigned char byAlarm);

VTC6221_API void RegisterSystemAlarmCallBackFunction(
	EventSystemAlarm_CallBack fnESA);
