﻿// VTC6221 API V1.0 2019/10/16
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Runtime.InteropServices;

namespace VTC6221_Utility
{
    class VTC6221
    {
        private const string DLL_PATH = "VTC6221.dll";

        [DllImport(DLL_PATH)]
        public static extern void Get_DLL_Version(ref int pnMajorVersion, ref int pnMinorVersion);

        [DllImport(DLL_PATH, CharSet = CharSet.Ansi)]
        public static extern bool Get_BIOS_Version(StringBuilder szBIOS_Ver, int nLen);

        [DllImport(DLL_PATH, CharSet = CharSet.Unicode)]
        public static extern bool Get_BIOS_Version_W(string szBIOS_Ver, int nLen);

        [DllImport(DLL_PATH)]
        public static extern int Connect();

        [DllImport(DLL_PATH)]
        public static extern void Disconnect();

        [DllImport(DLL_PATH)]
        public static extern int GetMCUVersion(ref int pnMCUVersion);

        [DllImport(DLL_PATH)]
        public static extern int GetHWVersion(ref int pnHWVersion);

        [DllImport(DLL_PATH)]
        public static extern int GetDTPVersion(ref int pnDTPVersion);

        [DllImport(DLL_PATH)]
        public static extern int GetBLVersion(ref int pnBLVersion);

        [DllImport(DLL_PATH)]
        public static extern int GetIgnitionStatus(ref int pnIgnitionStatus);

        [DllImport(DLL_PATH)]
        public static extern int GetSupplyVoltage(ref int pnSupplyVoltage);

        [DllImport(DLL_PATH)]
        public static extern int GetPowerType(ref int pnPowerType);

        [DllImport(DLL_PATH)]
        public static extern int GetDelayTimeOption(ref int pnPowerOff, ref int pnPowerOn, ref int pnDelayOffEnable, ref int pnDelayOnEnable);

        [DllImport(DLL_PATH)]
        public static extern int GetStartupShutdownOption(ref int pnStartupShutdownOption);

        [DllImport(DLL_PATH)]
        public static extern int GetAlarmTimer(ref int pnHour, ref int pnMin, ref int pnSec);

        [DllImport(DLL_PATH)]
        public static extern int GetWWANStatus(ref int pnWWAN_Enable, ref int pnWWAN_Enable2, ref int pnWWAN_Enable3, ref int pnWWAN_Wakeup_Enable3, ref int pnWWAN_Enable4);

        [DllImport(DLL_PATH)]
        public static extern int GetWiFiStatus(ref int pnWiFi_En1, ref int pnWiFi_En2, ref int pnWiFi_En3, ref int pnWiFi_Pw1, ref int pnWiFi_Pw2, ref int pnWiFi_Pw3);

        [DllImport(DLL_PATH)]
        public static extern int GetBTStatus(ref int pnBTStatus1, ref int pnBTStatus2, ref int pnBTStatus3);

        [DllImport(DLL_PATH)]
        public static extern int GetGPSStatus(ref int pnGPSStatus);

        [DllImport(DLL_PATH)]
        public static extern int GetUSBStatus(ref int pnUSB2_1, ref int pnUSB2_2, ref int pnUSB3, ref int pnUSB_RES);

        [DllImport(DLL_PATH)]
        public static extern int GetRTCStatus(ref int pnRTCStatus);

        [DllImport(DLL_PATH)]
        public static extern int GetWatchdogConfig(ref int pnWDT_Enable, ref int pnTimeInterval);

        [DllImport(DLL_PATH)]
        public static extern int GetGsensorData(int nRegisterIndex, byte[] pbyGsensorData, int nGsensorDataLen);

        [DllImport(DLL_PATH)]
        public static extern int GetSIMCardStatus(ref int pnSIMCard1, ref int pnSIMCard2, ref int pnSIMCard3, ref int pnSIMCard4);

        [DllImport(DLL_PATH)]
        public static extern int GetGPOStatus(ref int pnGPO1, ref int pnGPO2, ref int pnGPO3, ref int pnGPO4);

        [DllImport(DLL_PATH)]
        public static extern int GetGPIStatus(ref int pnGPI1, ref int pnGPI2, ref int pnGPI3, ref int pnGPI4);

        [DllImport(DLL_PATH)]
        public static extern int GetProgramLEDStatus(ref int pnLED_1, ref int pnLED_2, ref int pnLED_3, ref int pnLED_Alarm);

        [DllImport(DLL_PATH)]
        public static extern int GetWakeOnLanStatus(ref int pnWakeOnLanStatus);

        [DllImport(DLL_PATH)]
        public static extern int GetExternal12VStatus(ref int pnExternal12VStatus);

        [DllImport(DLL_PATH)]
        public static extern int GetPCIESlotMode(ref int pnCN5, ref int pnCN23);

        [DllImport(DLL_PATH)]
        public static extern int SetLoadDefault();

        [DllImport(DLL_PATH)]
        public static extern int SetRTCTimer(int nHour, int nMin, int nSec);

        [DllImport(DLL_PATH)]
        public static extern int SetDelayTimeOption(int nPowerOffDelayTime, int nPowerOffDelayTime_Enable, int nPowerOnDelayTime, int nPowerOnDelayTime_Enable);

        [DllImport(DLL_PATH)]
        public static extern int SetStartupShutdownOption(int nOption);

        [DllImport(DLL_PATH)]
        public static extern int SetAlarmTimer(int nHour, int nMin, int nSec);

        [DllImport(DLL_PATH)]
        public static extern int SetWWANControl(int nWWAN_Enable, int nWWAN_Enable2, int nWWAN_Enable3, int nWWAN_Wakeup_Enable3, int nWWAN_Enable4);

        [DllImport(DLL_PATH)]
        public static extern int SetWiFiControl(int nWiFi_En1, int nWiFi_En2, int nWiFi_En3, int nWiFi_Pw1, int nWiFi_Pw2, int nWiFi_Pw3);

        [DllImport(DLL_PATH)]
        public static extern int SetBTControl(int nBT1, int nBT2, int nBT3);

        [DllImport(DLL_PATH)]
        public static extern int SetGPSControl(int nEnable);

        [DllImport(DLL_PATH)]
        public static extern int SetUSBControl(int nUSB2_1, int nUSB2_2, int nUSB3, int nUSB_RES);

        [DllImport(DLL_PATH)]
        public static extern int SetRTCControl(int nEnable);

        [DllImport(DLL_PATH)]
        public static extern int SetWatchdogControl(int nWDT_Enable);

        [DllImport(DLL_PATH)]
        public static extern int SetWatchdogTimer(int nTimeInterval);

        [DllImport(DLL_PATH)]
        public static extern int SetFlashUpdate();

        [DllImport(DLL_PATH)]
        public static extern int SetGsensorData(int nRegIdx, byte[] pbyData, int nLen);

        [DllImport(DLL_PATH)]
        public static extern int SetSIMCardSelect(int nSIMCardSelect1, int nSIMCardSelect2, int nSIMCardSelect3, int nSIMCardSelect4);

        [DllImport(DLL_PATH)]
        public static extern int SetGPOControl(int nGPO1, int nGPO2, int nGPO3, int nGPO4);

        [DllImport(DLL_PATH)]
        public static extern int SetProgramLEDControl(int nLED1, int nLED2, int nLED3, int nLED_Alarm);

        [DllImport(DLL_PATH)]
        public static extern int SetWakeOnLanControl(int nEnable);

        [DllImport(DLL_PATH)]
        public static extern int SetExternal12VControl(int nEnable);

        // ================================================================================================================================================
        // Call back function
        [UnmanagedFunctionPointer(CallingConvention.StdCall)]
        public delegate void EventSystemAlarm_CallBack(byte byAlarm);

        [DllImport(DLL_PATH)]
        public static extern void RegisterSystemAlarmCallBackFunction([MarshalAs(UnmanagedType.FunctionPtr)] EventSystemAlarm_CallBack fnESA);
    }
}
